/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate;

import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.util.fast.Enum2FloatMap;
import java.util.List;
import net.minecraft.world.level.biome.Biome;

public class BiomeClimateSettings {
    private final Enum2FloatMap<SolarTerm> seasonalTemperatures = new Enum2FloatMap<SolarTerm>(SolarTerm.class, 0.0f);
    private final Enum2FloatMap<SolarTerm> seasonalDownfalls = new Enum2FloatMap<SolarTerm>(SolarTerm.class, 0.0f);
    private float temperature;
    private float downfall;

    public BiomeClimateSettings(Biome biome, List<BiomesClimateSettings> biomesClimateSettingsList) {
        this();
        this.temperature = biome.getModifiedClimateSettings().f_47681_();
        this.downfall = biome.getModifiedClimateSettings().f_47683_();
        for (BiomesClimateSettings modifiers : biomesClimateSettingsList) {
            if (modifiers.temperature().isPresent()) {
                this.temperature = modifiers.temperature().get().floatValue();
            }
            if (!modifiers.downfall().isPresent()) continue;
            this.downfall = modifiers.downfall().get().floatValue();
        }
        this.seasonalTemperatures.fill(this.temperature);
        this.seasonalDownfalls.fill(this.downfall);
        boolean setTemp = false;
        for (BiomesClimateSettings modifiers : biomesClimateSettingsList) {
            if (modifiers.temperatureChanges().isPresent()) {
                modifiers.temperatureChanges().get().combine().forEach(this.seasonalTemperatures::add);
                setTemp = true;
            }
            if (!modifiers.downfallChanges().isPresent()) continue;
            modifiers.downfallChanges().get().combine().forEach(this.seasonalDownfalls::add);
        }
        if (!setTemp) {
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                this.seasonalTemperatures.add(solarTerm, solarTerm.getTemperatureChange());
            }
        }
    }

    public BiomeClimateSettings() {
    }

    public float getTemperature(SolarTerm solarTerm) {
        return this.seasonalTemperatures.get(solarTerm);
    }

    public float getTemperatureChange(SolarTerm solarTerm) {
        return this.seasonalTemperatures.get(solarTerm) - this.temperature;
    }

    public float getDownfall(SolarTerm solarTerm) {
        return this.seasonalDownfalls.get(solarTerm);
    }

    public float getDownfallChange(SolarTerm solarTerm) {
        return this.seasonalDownfalls.get(solarTerm) - this.downfall;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getDownfall() {
        return this.downfall;
    }
}

