/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.biome;

import com.teamtea.eclipticseasons.api.constant.biome.Rainfall;
import com.teamtea.eclipticseasons.api.constant.biome.Temperature;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.misc.ITranslatable;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public enum Humidity implements ITranslatable
{
    ARID(ChatFormatting.RED, 0.9f),
    DRY(ChatFormatting.GOLD, 0.95f),
    AVERAGE(ChatFormatting.GREEN, 1.0f),
    MOIST(ChatFormatting.BLUE, 1.1f),
    HUMID(ChatFormatting.DARK_BLUE, 1.2f);

    private final ChatFormatting color;
    private final float tempCoefficient;
    private static final Humidity[] humidity;

    private Humidity(ChatFormatting color, float tempCoefficient) {
        this.color = color;
        this.tempCoefficient = tempCoefficient;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    @Override
    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public Component getTranslation() {
        return Component.m_237115_((String)("info.eclipticseasons.environment.humidity." + this.getName())).m_130940_(this.color);
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    @Deprecated(forRemoval=true, since="0.12")
    public float getCoefficient() {
        return this.tempCoefficient;
    }

    public static Humidity[] collectValues() {
        return humidity;
    }

    @Deprecated(forRemoval=true, since="0.11")
    public Humidity above(int levelAttach) {
        return this.cycle(levelAttach);
    }

    public Humidity cycle(int levelAttach) {
        int ordinal = this.ordinal();
        if (ordinal + levelAttach < 0) {
            return ARID;
        }
        if (ordinal + levelAttach >= Humidity.collectValues().length) {
            return HUMID;
        }
        return Humidity.collectValues()[ordinal + levelAttach];
    }

    public static Humidity getHumid(float humid) {
        return Humidity.collectValues()[Mth.m_14143_((float)Mth.m_14036_((float)humid, (float)0.0f, (float)(Humidity.collectValues().length - 1)))];
    }

    @Deprecated
    public static Humidity getHumid(Rainfall rainfall, Temperature temperature) {
        int rOrder = rainfall.ordinal();
        int tOrder = temperature.ordinal();
        int level = Math.max(0, rOrder - Math.abs(rOrder - tOrder) / 2);
        return Humidity.collectValues()[level];
    }

    public static Humidity getHumid(float rainfall, float temperature) {
        if (CommonConfig.isCropHumidityTransition()) {
            return Humidity.getHumid(Humidity.getFloatHumidLevel(rainfall, temperature));
        }
        return Humidity.getHumid(Rainfall.getRainfallLevel(rainfall), Temperature.getTemperatureLevel(temperature));
    }

    public static Humidity getHumid(SolarTerm solarTerm, Holder<Biome> biomeHolder) {
        Biome biome = (Biome)biomeHolder.m_203334_();
        boolean ignore = true;
        float t = EclipticUtil.getTemperatureFloatConstant(solarTerm, biome, ignore);
        BiomeRain biomeRain = solarTerm.getBiomeRain(biomeHolder);
        float r = (EclipticUtil.getDownfallFloatConstant(solarTerm, biome, ignore) * 1.5f + biomeRain.getRainChance() * 0.5f) / 2.0f;
        return Humidity.getHumid(r, t);
    }

    public static float getFloatHumidLevel(float rainfall, float temperature) {
        if (!CommonConfig.isCropHumidityTransition()) {
            return Humidity.getHumid(rainfall, temperature).ordinal();
        }
        float t = Temperature.getTemperature(temperature);
        float r = Rainfall.getRainfall(rainfall);
        float rNorm = Mth.m_14036_((float)(r / (float)Rainfall.collectValues().length), (float)0.0f, (float)1.0f);
        float tNorm = Mth.m_14036_((float)(t / (float)Temperature.collectValues().length), (float)0.0f, (float)1.0f);
        return Math.max(0.0f, rNorm - Math.abs(rNorm - tNorm) / 2.0f) * (float)Humidity.collectValues().length;
    }

    public static Environment getEnvironment(float humidLevel) {
        if (!CommonConfig.isCropHumidityTransition()) {
            return Environment.collectValues()[Humidity.getHumid(humidLevel).ordinal()];
        }
        if (humidLevel < 0.75f) {
            return Environment.ARID;
        }
        if (humidLevel > (float)Humidity.collectValues().length - 0.75f) {
            return Environment.HUMID;
        }
        float v = humidLevel % 1.0f;
        int original = Mth.m_14143_((float)humidLevel);
        Humidity now = Humidity.collectValues()[original];
        ArrayList<Composition> compositions = new ArrayList<Composition>();
        if (v < 0.25f) {
            float v1 = v * 4.0f;
            compositions.add(new Composition(now, 0.5f + 0.5f * v1));
            compositions.add(new Composition(now.cycle(-1), 0.5f - 0.5f * v1));
        } else {
            if (v <= 0.75f) {
                compositions.add(new Composition(now, 1.0f));
                return Environment.collectValues()[original];
            }
            float v1 = (v - 0.75f) * 4.0f;
            compositions.add(new Composition(now, 1.0f - 0.5f * v1));
            compositions.add(new Composition(now.cycle(1), 0.5f * v1));
        }
        return new Environment(now, compositions);
    }

    static {
        humidity = Humidity.values();
    }

    public record Environment(Humidity base, List<Composition> compositions) {
        public static final Environment ARID = new Environment(ARID, List.of(new Composition(ARID, 1.0f)));
        public static final Environment DRY = new Environment(DRY, List.of(new Composition(DRY, 1.0f)));
        public static final Environment AVERAGE = new Environment(AVERAGE, List.of(new Composition(AVERAGE, 1.0f)));
        public static final Environment MOIST = new Environment(MOIST, List.of(new Composition(MOIST, 1.0f)));
        public static final Environment HUMID = new Environment(HUMID, List.of(new Composition(HUMID, 1.0f)));
        private static final Environment[] values = new Environment[]{ARID, DRY, AVERAGE, MOIST, HUMID};

        public static Environment[] collectValues() {
            return values;
        }
    }

    public record Composition(Humidity humidity, float percent) {
    }
}

