/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UndoRedoHelper {
    private final List<FieldState> history = new ArrayList<FieldState>();
    private int index = 0;

    public UndoRedoHelper(String text, int cursorPos, int selectionLength) {
        this.history.add(new FieldState(text, cursorPos, selectionLength));
    }

    public void save(String text, int cursorPos, int selectionLength) {
        int max = this.history.size();
        this.history.subList(this.index, max).clear();
        this.history.add(new FieldState(text, cursorPos, selectionLength));
        ++this.index;
    }

    @Nullable
    public FieldState undo() {
        --this.index;
        this.index = Math.max(this.index, 0);
        if (this.history.isEmpty()) {
            return null;
        }
        return this.history.get(this.index);
    }

    @Nullable
    public FieldState redo() {
        if (this.index < this.history.size() - 1) {
            ++this.index;
            return this.history.get(this.index);
        }
        return null;
    }

    public record FieldState(String text, int cursorPos, int selectionLength) {
    }
}

