/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.api;

import dev.isxander.yacl3.impl.GenericBindingImpl;
import dev.isxander.yacl3.mixin.OptionInstanceAccessor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.OptionInstance;
import org.apache.commons.lang3.Validate;

public interface Binding<T> {
    public void setValue(T var1);

    public T getValue();

    public T defaultValue();

    default public <U> Binding<U> xmap(Function<T, U> to, Function<U, T> from) {
        return Binding.generic(to.apply(this.defaultValue()), () -> to.apply(this.getValue()), v -> this.setValue(from.apply(v)));
    }

    public static <T> Binding<T> generic(T def, Supplier<T> getter, Consumer<T> setter) {
        Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
        Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
        Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
        return new GenericBindingImpl<T>(def, getter, setter);
    }

    public static <T> Binding<T> minecraft(OptionInstance<T> minecraftOption) {
        Validate.notNull(minecraftOption, (String)"`minecraftOption` must not be null", (Object[])new Object[0]);
        return new GenericBindingImpl<Object>(((OptionInstanceAccessor)minecraftOption).getInitialValue(), () -> minecraftOption.m_231551_(), arg_0 -> minecraftOption.m_231514_(arg_0));
    }

    public static <T> Binding<T> immutable(T value) {
        Validate.notNull(value, (String)"`value` must not be null", (Object[])new Object[0]);
        return new GenericBindingImpl<Object>(value, () -> value, changed -> {});
    }
}

