/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.terminal.filters;

import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.IBasicTraderFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.PendingSearch;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class FluidTraderSearchFilter
implements IBasicTraderFilter {
    public static final String FLUID = "fluid";

    public void filterTrade(TradeData data, PendingSearch search) {
        FluidTradeData trade;
        if (data instanceof FluidTradeData && (trade = (FluidTradeData)data).isValid()) {
            search.processFilter(FLUID, FluidTraderSearchFilter.filterFluid(trade.getProduct()));
        }
    }

    public static Predicate<String> filterFluid(@Nonnull FluidStack fluid) {
        return input -> {
            if (input.isBlank()) {
                return false;
            }
            if (fluid.isEmpty()) {
                return "empty".contains((CharSequence)input);
            }
            if (FluidFormatUtil.getFluidName(fluid).getString().toLowerCase().contains((CharSequence)input)) {
                return true;
            }
            return BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).toString().toLowerCase().contains((CharSequence)input);
        };
    }
}

