/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid.settings;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.trades.TradeSettings;
import io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.trades.TradeSubNode;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTradeSettings
extends TradeSettings<FluidTraderData> {
    public FluidTradeSettings(FluidTraderData trader) {
        super("fluid_trades", (TraderData)trader);
    }

    @Nullable
    protected FluidTradeData getRuleHost(int tradeIndex) {
        return tradeIndex >= 0 && tradeIndex < ((FluidTraderData)this.trader).getTradeCount() ? ((FluidTraderData)this.trader).getTrade(tradeIndex) : null;
    }

    protected SettingsSubNode<?> createTradeNode(int tradeIndex) {
        return new TradeNode(this, tradeIndex);
    }

    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        data.setIntValue("trade_count", ((FluidTraderData)this.trader).getTradeCount());
    }

    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        int newCount;
        if (context.isServerAdmin() && data.hasIntValue("trade_count") && (newCount = data.getIntValue("trade_count")) < ((FluidTraderData)this.trader).getTradeCount()) {
            ((FluidTraderData)this.trader).overrideTradeCount(newCount);
        }
    }

    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        lineWriter.accept((Component)FluidTradeSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_COUNT.get(new Object[0]), (int)data.getIntValue("trade_count")));
    }

    private static class TradeNode
    extends TradeSubNode<FluidTradeData, FluidTradeSettings> {
        public TradeNode(FluidTradeSettings parent, int index) {
            super((SettingsNode)parent, index);
        }

        @Nullable
        protected FluidTradeData getTrade() {
            return ((FluidTradeSettings)this.parent).getRuleHost(this.index);
        }

        protected void saveTrade(SavedSettingData.MutableNodeAccess node, FluidTradeData trade) {
            node.setStringValue("type", trade.getTradeDirection().toString());
            node.setCompoundValue("price", trade.getCost().save());
            node.setCompoundValue("fluid", trade.getProduct().writeToNBT(new CompoundTag()));
            node.setIntValue("buckets", trade.getBucketQuantity());
        }

        protected void loadTrade(SavedSettingData.NodeAccess node, FluidTradeData trade, LoadContext context) {
            trade.setTradeDirection((TradeDirection)EnumUtil.enumFromString((String)node.getStringValue("type"), (Enum[])TradeDirection.values(), (Enum)TradeDirection.SALE));
            trade.setCost(MoneyValue.load((CompoundTag)node.getCompoundValue("price")));
            trade.setProduct(FluidStack.loadFluidStackFromNBT((CompoundTag)node.getCompoundValue("fluid")));
            trade.setBucketQuantity(node.getIntValue("buckets"));
        }

        protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
            TradeDirection type = (TradeDirection)EnumUtil.enumFromString((String)data.getStringValue("type"), (Enum[])TradeDirection.values(), (Enum)TradeDirection.SALE);
            lineWriter.accept((Component)SettingsNode.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_TYPE.get(new Object[0]), (Component)LCText.GUI_TRADE_DIRECTION.get((Object)type).get(new Object[0])));
            lineWriter.accept((Component)SettingsNode.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_PRICE.get(new Object[0]), (Component)MoneyValue.load((CompoundTag)data.getCompoundValue("price")).getText()));
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)data.getCompoundValue("fluid"));
            int buckets = data.getIntValue("buckets");
            lineWriter.accept((Component)TechText.DATA_ENTRY_TRADER_TRADE_FLUID.get(new Object[]{FluidFormatUtil.getFluidName(fluid, ChatFormatting.RESET), buckets}));
        }
    }
}

