/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.energy;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy.EnergyTradeEditClientTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnergyTradeEditTab
extends TraderStorageTab {
    int tradeIndex = -1;

    public EnergyTradeEditTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object menu) {
        return new EnergyTradeEditClientTab(menu, this);
    }

    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public EnergyTradeData getTrade() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                ((ITraderStorageMenu)this.menu).ChangeTab(0);
                return null;
            }
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void onTabOpen() {
    }

    public void onTabClose() {
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(TradeDirection type) {
        EnergyTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeDirection(type);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleInt((String)"NewType", (int)type.index));
            }
        }
    }

    public void setQuantity(int amount) {
        EnergyTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setAmount(amount);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleInt((String)"NewQuantity", (int)amount));
            }
        }
    }

    public void setPrice(MoneyValue price) {
        EnergyTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleMoneyValue((String)"NewPrice", (MoneyValue)price));
            }
        }
    }

    public void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("NewQuantity")) {
            this.setQuantity(message.getInt("NewQuantity"));
        } else if (message.contains("NewPrice")) {
            this.setPrice(message.getMoneyValue("NewPrice"));
        } else if (message.contains("NewType")) {
            this.setType(TradeDirection.fromIndex((int)message.getInt("NewType")));
        }
    }
}

