/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderDataManager;
import io.github.lightman314.lctech.client.util.FluidSides;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankBlockEntity;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.TankStackState;
import io.github.lightman314.lctech.common.blocks.IFluidTankBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.blocks.EasyBlock;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FluidTankBlock
extends EasyBlock
implements IEasyEntityBlock,
IFluidTankBlock {
    public static final VoxelShape SHAPE = LazyShapes.BOX;
    public static final ResourceLocation DATA_SOLO = VersionUtil.modResource((String)"lctech", (String)"fluid_tank/solo");
    public static final ResourceLocation DATA_TOP = VersionUtil.modResource((String)"lctech", (String)"fluid_tank/top");
    public static final ResourceLocation DATA_MIDDLE = VersionUtil.modResource((String)"lctech", (String)"fluid_tank/middle");
    public static final ResourceLocation DATA_BOTTOM = VersionUtil.modResource((String)"lctech", (String)"fluid_tank/bottom");
    private final VoxelShape shape;
    private final Supplier<Integer> tankCapacity;

    public int getTankCapacity() {
        return Math.max(this.tankCapacity.get(), 1000);
    }

    public FluidTankBlock(int tankCapacity, BlockBehaviour.Properties properties) {
        this(() -> tankCapacity, properties, SHAPE);
    }

    public FluidTankBlock(Supplier<Integer> tankCapacity, BlockBehaviour.Properties properties) {
        this(tankCapacity, properties, SHAPE);
    }

    public FluidTankBlock(int tankCapacity, BlockBehaviour.Properties properties, VoxelShape shape) {
        this(() -> tankCapacity, properties, shape);
    }

    public FluidTankBlock(Supplier<Integer> tankCapacity, BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)TANK_STATE, (Comparable)((Object)TankStackState.SOLO)));
        this.tankCapacity = tankCapacity;
        this.shape = shape;
    }

    protected boolean isBlockOpaque() {
        return false;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TANK_STATE});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape;
    }

    public void m_6402_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity player, @NotNull ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
            tank.loadFromItem(stack);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (result.m_82434_().m_122434_().m_122478_() && player.m_21120_(hand).m_41720_() instanceof BlockItem) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
            return tank.onInteraction(player, hand);
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && !player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity be = (FluidTankBlockEntity)blockEntity;
            FluidTankBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)FluidTankItem.GetItemFromTank(be));
        }
        super.m_5707_(level, pos, state, player);
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return FluidTankItem.GetItemFromTank((FluidTankBlockEntity)blockEntity);
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public FluidRenderData getItemRenderData() {
        return FluidRenderDataManager.getDataOrEmpty(DATA_SOLO);
    }

    @Override
    public FluidRenderData getRenderData(BlockState state, boolean lighterThanAir, FluidTankBlockEntity tank, @Nullable FluidTankBlockEntity nextTank) {
        switch (this.getTankState(tank.m_58900_())) {
            case BOTTOM: {
                FluidRenderData data = FluidRenderDataManager.getDataOrEmpty(DATA_BOTTOM);
                if (lighterThanAir) {
                    return data.withSides(FluidSides.NO_TOP);
                }
                return data.withSides(this.hideNextFace(tank, nextTank) ? FluidSides.NO_TOP : FluidSides.ALL);
            }
            case TOP: {
                FluidRenderData data = FluidRenderDataManager.getDataOrEmpty(DATA_TOP);
                return data.withSides(!lighterThanAir || this.hideNextFace(tank, nextTank), FluidSides.NO_BOTTOM);
            }
            case MIDDLE: {
                FluidRenderData data = FluidRenderDataManager.getDataOrEmpty(DATA_MIDDLE);
                if (lighterThanAir) {
                    return data.withSides(this.hideNextFace(tank, nextTank), FluidSides.NO_TOP_OR_BOTTOM, FluidSides.NO_TOP);
                }
                return data.withSides(this.hideNextFace(tank, nextTank), FluidSides.NO_TOP_OR_BOTTOM, FluidSides.NO_BOTTOM);
            }
        }
        return FluidRenderDataManager.getDataOrEmpty(DATA_SOLO);
    }

    private boolean hideNextFace(FluidTankBlockEntity tank, @Nullable FluidTankBlockEntity nextTank) {
        return tank.getTankFillPercent() >= 1.0 && nextTank != null && nextTank.getTankFillPercent() > 0.0;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FluidTankBlockEntity(pos, state);
    }

    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return ImmutableList.of(ModBlockEntities.FLUID_TANK.get());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        BlockEntity blockEntity;
        if (facing.m_122434_().m_122478_() && (blockEntity = worldIn.m_7702_(currentPos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
            tank.enqueTankStackRefactor();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

