/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.blockentities.handler.FluidInterfaceHandler;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import io.github.lightman314.lctech.common.menu.traderinterface.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyMenuTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity
implements TraderFluidStorage.ITraderFluidFilter {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.FLUID_CAPACITY});
    private final TraderFluidStorage fluidBuffer = new TraderFluidStorage(this);
    FluidInterfaceHandler fluidHandler = (FluidInterfaceHandler)this.addHandler((SidedHandler)new FluidInterfaceHandler(this));
    private int refactorTimer = 0;

    public TraderFluidStorage getFluidBuffer() {
        return this.fluidBuffer;
    }

    public FluidInterfaceHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public FluidTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TRADER_INTERFACE_FLUID.get(), pos, state);
    }

    public void setInteractionDirty() {
        super.setInteractionDirty();
        if (this.fluidBuffer.refactorTanks()) {
            this.setFluidBufferDirty();
        }
    }

    public void setTargetsDirty() {
        super.setTargetsDirty();
        if (this.fluidBuffer.refactorTanks()) {
            this.setFluidBufferDirty();
        }
    }

    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withFluidHandler((IFluidHandler)this.fluidBuffer);
    }

    public boolean allowInput(FluidStack fluid) {
        if (this.getInteractionType().trades()) {
            for (TradeReference tr : this.targets.getTradeReferences()) {
                FluidTradeData trade;
                TradeData t = tr.getLocalTrade();
                if (!(t instanceof FluidTradeData) || !(trade = (FluidTradeData)t).isPurchase() || !trade.getProduct().isFluidEqual(fluid)) continue;
                return true;
            }
        } else {
            for (TraderData trader : this.targets.getTraders()) {
                if (!(trader instanceof FluidTraderData)) continue;
                FluidTraderData ft = (FluidTraderData)trader;
                for (FluidTradeData trade : ft.getTradeData()) {
                    if (!trade.isSale() || !trade.getProduct().isFluidEqual(fluid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean allowOutput(FluidStack fluid) {
        return !this.allowInput(fluid);
    }

    @Override
    public List<FluidStack> getRelevantFluids() {
        if (this.getInteractionType().trades()) {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>();
            for (TradeReference tr : this.targets.getTradeReferences()) {
                FluidTradeData trade;
                TradeData t = tr.getLocalTrade();
                if (!(t instanceof FluidTradeData) || (trade = (FluidTradeData)t).getProduct().isEmpty()) continue;
                FluidItemUtil.addFluidToRelevanceList(result, trade.getProduct());
            }
            return result;
        }
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        for (TraderData t : this.targets.getTraders()) {
            if (!(t instanceof FluidTraderData)) continue;
            FluidTraderData trader = (FluidTraderData)t;
            FluidItemUtil.addFluidsToRelevanceList(result, trader.getRelevantFluids());
        }
        return result;
    }

    @Override
    public int getTankCapacity() {
        int defaultCapacity;
        int tankCapacity = defaultCapacity = FluidTraderData.getDefaultTankCapacity();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != TechUpgradeTypes.FLUID_CAPACITY) continue;
            int addAmount = UpgradeItem.getUpgradeData((ItemStack)stack).getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            tankCapacity += addAmount;
        }
        return tankCapacity;
    }

    public FluidTradeData deserializeTrade(@Nonnull CompoundTag compound) {
        return FluidTradeData.loadData(compound, false);
    }

    protected void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveFluidBuffer(compound);
    }

    protected final CompoundTag saveFluidBuffer(CompoundTag compound) {
        this.fluidBuffer.save(compound, "Storage");
        return compound;
    }

    public void setFluidBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)this.saveFluidBuffer(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Storage")) {
            this.fluidBuffer.load(compound, "Storage");
        }
    }

    public boolean validTraderType(TraderData trader) {
        return trader instanceof FluidTraderData;
    }

    public void serverTick() {
        --this.refactorTimer;
        if (this.refactorTimer <= 0) {
            this.refactorTimer = 20;
            if (this.fluidBuffer.refactorTanks()) {
                this.setFluidBufferDirty();
            }
        }
        super.serverTick();
    }

    protected void drainTick(@Nonnull TraderData t) {
        FluidTraderData trader;
        if (t instanceof FluidTraderData && (trader = (FluidTraderData)t).hasPermission(this.getReferencedPlayer(), "interactionLink")) {
            TraderFluidStorage storage = trader.getStorage();
            boolean setChanged = false;
            for (FluidTradeData trade : trader.getTradeData()) {
                FluidStack drainFluid;
                int drainableAmount;
                if (!trade.isValid() || !trade.isPurchase() || (drainableAmount = Math.min(storage.getActualFluidCount(drainFluid = trade.getProduct()), this.fluidBuffer.getFillableAmount(drainFluid))) <= 0) continue;
                FluidStack movingStack = drainFluid.copy();
                movingStack.setAmount(Math.min((Integer)TechConfig.SERVER.fluidRestockSpeed.get(), drainableAmount));
                storage.drain(movingStack);
                this.fluidBuffer.forceFillTank(movingStack);
                setChanged = true;
            }
            if (setChanged) {
                trader.markStorageDirty();
                this.setFluidBufferDirty();
            }
        }
    }

    protected void restockTick(@Nonnull TraderData t) {
        FluidTraderData trader;
        if (t instanceof FluidTraderData && (trader = (FluidTraderData)t).hasPermission(this.getReferencedPlayer(), "interactionLink")) {
            TraderFluidStorage storage = trader.getStorage();
            boolean setChanged = false;
            for (FluidTradeData trade : trader.getTradeData()) {
                FluidStack fillFluid;
                int drainableAmount;
                if (!trade.isValid() || !trade.isSale() || (drainableAmount = Math.min(storage.getFillableAmount(fillFluid = trade.getProduct()), this.fluidBuffer.getActualFluidCount(fillFluid))) <= 0) continue;
                FluidStack movingStack = fillFluid.copy();
                movingStack.setAmount(Math.min((Integer)TechConfig.SERVER.fluidRestockSpeed.get(), drainableAmount));
                storage.forceFillTank(movingStack);
                this.fluidBuffer.drain(movingStack);
                setChanged = true;
            }
            if (setChanged) {
                trader.markStorageDirty();
                this.setFluidBufferDirty();
            }
        }
    }

    protected void tradeTick(@Nonnull TradeReference tr) {
        FluidTradeData trade;
        TradeData t = tr.getTrueTrade();
        if (t instanceof FluidTradeData && (trade = (FluidTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.fluidBuffer.getFillableAmount(trade.getProduct()) >= trade.getQuantity() && this.TryExecuteTrade(tr).isSuccess()) {
                    this.setFluidBufferDirty();
                }
            } else if (trade.isPurchase() && this.fluidBuffer.getActualFluidCount(trade.getProduct()) >= trade.getQuantity() && this.TryExecuteTrade(tr).isSuccess()) {
                this.setFluidBufferDirty();
            }
        }
    }

    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (Direction relativeSide : Direction.values()) {
            BlockPos queryPos;
            BlockEntity be;
            IFluidHandler fluidHandler;
            if (!this.fluidHandler.allowInputSide(relativeSide) && !this.fluidHandler.allowOutputSide(relativeSide)) continue;
            Direction actualSide = relativeSide;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)block;
                actualSide = IRotatableBlock.getActualSide((Direction)b.getFacing(this.m_58900_()), (Direction)relativeSide);
            }
            IFluidHandler iFluidHandler = fluidHandler = (be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_121945_(actualSide))) == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, actualSide.m_122424_()).orElse(null);
            if (fluidHandler == null) continue;
            if (this.fluidHandler.allowInputSide(relativeSide)) {
                boolean query = true;
                for (int i = 0; query && i < fluidHandler.getTanks(); ++i) {
                    FluidStack stack = fluidHandler.getFluidInTank(i);
                    int fillableAmount = this.fluidBuffer.getFillableAmount(stack);
                    if (fillableAmount <= 0) continue;
                    query = false;
                    FluidStack drainStack = stack.copy();
                    drainStack.setAmount(fillableAmount);
                    FluidStack result = fluidHandler.drain(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidBuffer.forceFillTank(result);
                    markBufferDirty.set(true);
                }
            }
            if (!this.fluidHandler.allowOutputSide(relativeSide)) continue;
            List<TraderFluidStorage.FluidEntry> entries = this.fluidBuffer.getContents();
            boolean query = true;
            for (int i = 0; query && i < entries.size(); ++i) {
                int fillAmount;
                FluidStack fluid = entries.get(i).getTankContents();
                if (!this.allowOutput(fluid) || (fillAmount = fluidHandler.fill(fluid.copy(), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                query = false;
                if (!fluid.isEmpty()) {
                    fluid.setAmount(fillAmount);
                }
                this.fluidBuffer.drain(fluid);
                markBufferDirty.set(true);
            }
        }
        if (markBufferDirty.get()) {
            this.setFluidBufferDirty();
        }
    }

    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, (EasyMenuTab)new FluidStorageTab(menu));
    }

    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public void getAdditionalContents(List<ItemStack> contents) {
        this.fluidBuffer.getContents().forEach(entry -> {
            if (!entry.getTankContents().isEmpty()) {
                contents.add(FluidShardItem.GetFluidShard(entry.getTankContents()));
            }
        });
    }
}

