/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.gen.chunk_region;

import java.util.List;
import me.jellysquid.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenRegion.class})
public abstract class ChunkRegionMixin
implements WorldGenLevel {
    @Shadow
    @Final
    private ChunkPos f_9487_;
    @Shadow
    @Final
    private int f_9478_;
    private ChunkAccess[] chunksArr;
    private int minChunkX;
    private int minChunkZ;

    @Inject(method={"<init>(Lnet/minecraft/server/world/ServerWorld;Ljava/util/List;Lnet/minecraft/world/chunk/ChunkStatus;I)V"}, at={@At(value="RETURN")})
    private void init(ServerLevel world, List<ChunkAccess> chunks, ChunkStatus chunkStatus, int i, CallbackInfo ci) {
        this.minChunkX = this.f_9487_.f_45578_;
        this.minChunkZ = this.f_9487_.f_45579_;
        this.chunksArr = chunks.toArray(new ChunkAccess[0]);
    }

    @Overwrite
    public BlockState m_8055_(BlockPos pos) {
        int x = Pos.ChunkCoord.fromBlockCoord(pos.m_123341_()) - this.minChunkX;
        int z = Pos.ChunkCoord.fromBlockCoord(pos.m_123343_()) - this.minChunkZ;
        int w = this.f_9478_;
        if (x >= 0 && z >= 0 && x < w && z < w) {
            return this.chunksArr[x + z * w].m_8055_(pos);
        }
        throw new NullPointerException("No chunk exists at " + new ChunkPos(pos));
    }

    @Overwrite
    public ChunkAccess m_6325_(int chunkX, int chunkZ) {
        int x = chunkX - this.minChunkX;
        int z = chunkZ - this.minChunkZ;
        int w = this.f_9478_;
        if (x >= 0 && z >= 0 && x < w && z < w) {
            return this.chunksArr[x + z * w];
        }
        throw new NullPointerException("No chunk exists at " + new ChunkPos(chunkX, chunkZ));
    }

    public ChunkAccess m_46865_(BlockPos pos) {
        return this.m_6325_(Pos.ChunkCoord.fromBlockCoord(pos.m_123341_()), Pos.ChunkCoord.fromBlockCoord(pos.m_123343_()));
    }
}

