/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.experimental.entity.block_caching.fire_lava_touching;

import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCache;
import me.jellysquid.mods.lithium.common.entity.block_tracking.BlockCacheProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements BlockCacheProvider {
    private static final Stream<BlockState> EMPTY_BLOCKSTATE_STREAM = Stream.empty();
    @Shadow
    private int f_19831_;
    @Shadow
    public boolean f_146810_;
    @Shadow
    public boolean f_146808_;

    @Shadow
    protected abstract int m_6101_();

    @Shadow
    public abstract boolean m_20071_();

    @Redirect(method={"move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getStatesInBoxIfLoaded(Lnet/minecraft/util/math/Box;)Ljava/util/stream/Stream;"))
    private Stream<BlockState> skipFireTestIfResultDoesNotMatterOrIsCached(Level world, AABB box) {
        if (!(this.f_19831_ <= 0 && this.f_19831_ != -this.m_6101_() || this.f_146810_ && (this.f_146808_ || this.m_20071_()))) {
            return null;
        }
        BlockCache bc = this.getUpdatedBlockCache((Entity)this);
        byte cachedTouchingFireLava = bc.getIsTouchingFireLava();
        if (cachedTouchingFireLava == 0) {
            return null;
        }
        if (cachedTouchingFireLava == 1) {
            return EMPTY_BLOCKSTATE_STREAM;
        }
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)box.f_82293_);
        if (maxY >= world.m_141937_() && minY < world.m_151558_() && world.m_151572_(minX, minZ, maxX, maxZ)) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        blockPos.m_122178_(x, y, z);
                        BlockState state = world.m_8055_((BlockPos)blockPos);
                        if (!state.m_204336_(BlockTags.f_13076_) && !state.m_60713_(Blocks.f_49991_)) continue;
                        bc.setCachedTouchingFireLava(true);
                        return EMPTY_BLOCKSTATE_STREAM;
                    }
                }
            }
        }
        bc.setCachedTouchingFireLava(false);
        return null;
    }

    @Redirect(method={"move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;noneMatch(Ljava/util/function/Predicate;)Z"))
    private boolean skipNullStream(Stream<BlockState> stream, Predicate<BlockState> predicate) {
        return stream == null;
    }
}

