/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.collisions.fluid;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import me.jellysquid.mods.lithium.common.block.BlockCountingSection;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import me.jellysquid.mods.lithium.common.entity.FluidCachingEntity;
import me.jellysquid.mods.lithium.common.util.Pos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class}, priority=900)
public abstract class EntityMixin
implements FluidCachingEntity,
IForgeEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    protected Object2DoubleMap<FluidType> forgeFluidTypeHeight;
    @Shadow
    @Deprecated
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;
    @Shadow
    public float f_19789_;
    private boolean radium$isInModdedFluid;

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    abstract void m_20074_();

    @Shadow
    public abstract boolean isInFluidType();

    @Shadow
    @Nullable
    public abstract Entity m_20202_();

    @Shadow
    public abstract void m_20095_();

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isPushedByFluids()Z", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, require=0)
    public void tryShortcutFluidPushing(CallbackInfo ci, AABB box, int x1, int x2, int y1, int y2, int z1, int z2, double zero) {
        int chunkX1 = x1 >> 4;
        int chunkZ1 = z1 >> 4;
        int chunkX2 = x2 - 1 >> 4;
        int chunkZ2 = z2 - 1 >> 4;
        int chunkYIndex1 = Math.max(Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.f_19853_, y1), Pos.SectionYIndex.getMinYSectionIndex((LevelHeightAccessor)this.f_19853_));
        int chunkYIndex2 = Math.min(Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.f_19853_, y2 - 1), Pos.SectionYIndex.getMaxYSectionIndexInclusive((LevelHeightAccessor)this.f_19853_));
        for (int chunkX = chunkX1; chunkX <= chunkX2; ++chunkX) {
            for (int chunkZ = chunkZ1; chunkZ <= chunkZ2; ++chunkZ) {
                LevelChunk chunk = this.f_19853_.m_6325_(chunkX, chunkZ);
                for (int chunkYIndex = chunkYIndex1; chunkYIndex <= chunkYIndex2; ++chunkYIndex) {
                    LevelChunkSection section = chunk.m_7103_()[chunkYIndex];
                    if (!((BlockCountingSection)section).mayContainAny(BlockStateFlags.ANY_FLUID)) continue;
                    return;
                }
            }
        }
        if (!this.forgeFluidTypeHeight.isEmpty()) {
            this.forgeFluidTypeHeight.clear();
        }
        ci.cancel();
    }

    @Inject(method={"setFluidTypeHeight"}, at={@At(value="RETURN")})
    private void markInModdedFluid(FluidType type, double height, CallbackInfo ci) {
        if (!type.isAir() && !type.isVanilla()) {
            this.radium$isInModdedFluid = true;
        }
    }

    @Overwrite
    protected boolean m_20073_() {
        this.f_19799_.clear();
        this.forgeFluidTypeHeight.clear();
        this.radium$isInModdedFluid = false;
        this.m_20074_();
        if (this.radium$isInModdedFluid && !(this.m_20202_() instanceof Boat)) {
            float fallDistanceModifier = Float.MAX_VALUE;
            boolean canExtinguish = false;
            for (FluidType type : this.forgeFluidTypeHeight.keySet()) {
                if (type.isAir() || type.isVanilla()) continue;
                fallDistanceModifier = Math.min(this.getFluidFallDistanceModifier(type), fallDistanceModifier);
                canExtinguish |= this.canFluidExtinguish(type);
            }
            if (fallDistanceModifier != Float.MAX_VALUE) {
                this.f_19789_ *= fallDistanceModifier;
            }
            if (canExtinguish) {
                this.m_20095_();
            }
        }
        return this.isInFluidType();
    }

    @Overwrite
    public final boolean isInFluidType(BiPredicate<FluidType, Double> predicate, boolean forAllTypes) {
        if (this.forgeFluidTypeHeight.isEmpty()) {
            return false;
        }
        ObjectIterator it = Object2DoubleMaps.fastIterator(this.forgeFluidTypeHeight);
        if (forAllTypes) {
            while (it.hasNext()) {
                Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)it.next();
                if (predicate.test((FluidType)entry.getKey(), entry.getDoubleValue())) continue;
                return false;
            }
            return true;
        }
        while (it.hasNext()) {
            Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)it.next();
            if (!predicate.test((FluidType)entry.getKey(), entry.getDoubleValue())) continue;
            return true;
        }
        return false;
    }
}

