/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.chunk;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class LithiumHashPalette<T>
implements Palette<T> {
    private static final int ABSENT_VALUE = -1;
    private final IdMap<T> idList;
    private final PaletteResize<T> resizeHandler;
    private final int indexBits;
    private final Reference2IntMap<T> table;
    private T[] entries;
    private int size = 0;

    public LithiumHashPalette(IdMap<T> idList, PaletteResize<T> resizeHandler, int indexBits, T[] entries, Reference2IntMap<T> table, int size) {
        this.idList = idList;
        this.resizeHandler = resizeHandler;
        this.indexBits = indexBits;
        this.entries = entries;
        this.table = table;
        this.size = size;
    }

    public LithiumHashPalette(IdMap<T> idList, int bits, PaletteResize<T> resizeHandler, List<T> list) {
        this(idList, bits, resizeHandler);
        for (T t : list) {
            this.addEntry(t);
        }
    }

    public LithiumHashPalette(IdMap<T> idList, int bits, PaletteResize<T> resizeHandler) {
        this.idList = idList;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        int capacity = 1 << bits;
        this.entries = new Object[capacity];
        this.table = new Reference2IntOpenHashMap(capacity, 0.5f);
        this.table.defaultReturnValue(-1);
    }

    public int m_6796_(T obj) {
        int id = this.table.getInt(obj);
        if (id == -1) {
            id = this.computeEntry(obj);
        }
        return id;
    }

    public boolean m_6419_(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.entries[i])) continue;
            return true;
        }
        return false;
    }

    private int computeEntry(T obj) {
        int id = this.addEntry(obj);
        if (id >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.m_7248_(this.indexBits + 1, obj);
        }
        return id;
    }

    private int addEntry(T obj) {
        int nextId = this.size;
        if (nextId >= this.entries.length) {
            this.resize(this.size);
        }
        this.table.put(obj, nextId);
        this.entries[nextId] = obj;
        ++this.size;
        return nextId;
    }

    private void resize(int neededCapacity) {
        this.entries = Arrays.copyOf(this.entries, HashCommon.nextPowerOfTwo((int)(neededCapacity + 1)));
    }

    public T m_5795_(int id) {
        T[] entries = this.entries;
        if (id >= 0 && id < entries.length) {
            return entries[id];
        }
        return null;
    }

    public void m_5680_(FriendlyByteBuf buf) {
        this.clear();
        int entryCount = buf.m_130242_();
        for (int i = 0; i < entryCount; ++i) {
            this.addEntry(this.idList.m_7942_(buf.m_130242_()));
        }
    }

    public void m_5678_(FriendlyByteBuf buf) {
        int size = this.size;
        buf.m_130130_(size);
        for (int i = 0; i < size; ++i) {
            buf.m_130130_(this.idList.m_7447_(this.m_5795_(i)));
        }
    }

    public int m_6429_() {
        int size = FriendlyByteBuf.m_130053_((int)this.size);
        for (int i = 0; i < this.size; ++i) {
            size += FriendlyByteBuf.m_130053_((int)this.idList.m_7447_(this.m_5795_(i)));
        }
        return size;
    }

    public int m_62680_() {
        return this.size;
    }

    public Palette<T> m_199814_() {
        return new LithiumHashPalette<Object>((IdMap<Object>)this.idList, (PaletteResize<Object>)this.resizeHandler, this.indexBits, (T[])((Object[])this.entries.clone()), (Reference2IntMap<Object>)new Reference2IntOpenHashMap(this.table), this.size);
    }

    private void clear() {
        Arrays.fill(this.entries, null);
        this.table.clear();
        this.size = 0;
    }

    public List<T> getElements() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (T entry : this.entries) {
            if (entry == null) continue;
            builder.add(entry);
        }
        return builder.build();
    }

    public static <A> Palette<A> create(int bits, IdMap<A> idList, PaletteResize<A> listener, List<A> list) {
        return new LithiumHashPalette<A>(idList, bits, listener, list);
    }
}

