/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.block.entity.NetherStoveBlockEntity;
import com.soytutta.mynethersdelight.common.registry.MNDBlockEntityTypes;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class NetherStoveBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty SOUL = BooleanProperty.m_61465_((String)"soul");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public NetherStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity;
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
                this.extinguish(state, level, pos);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem == Items.f_42447_) {
                if (!level.m_5776_()) {
                    level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, level, pos);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            BlockPos frontPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            boolean isNetherStove = (Boolean)state.m_61143_((Property)SOUL) == false;
            boolean isSoulNetherStove = (Boolean)state.m_61143_((Property)SOUL);
            if (isNetherStove && heldStack.m_204117_(MNDTags.STOVE_SOUL_FUEL) || isSoulNetherStove && heldStack.m_204117_(MNDTags.STOVE_FIRE_FUEL)) {
                int i;
                SimpleParticleType particle2;
                SimpleParticleType particle1;
                SoundEvent sound2;
                SoundEvent sound1;
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (isNetherStove) {
                    sound1 = SoundEvents.f_12404_;
                    sound2 = SoundEvents.f_11921_;
                    particle1 = ParticleTypes.f_123746_;
                    particle2 = ParticleTypes.f_123745_;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOUL, (Comparable)Boolean.TRUE), 11);
                } else {
                    sound1 = SoundEvents.f_11913_;
                    sound2 = SoundEvents.f_11705_;
                    particle1 = ParticleTypes.f_123756_;
                    particle2 = ParticleTypes.f_123744_;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOUL, (Comparable)Boolean.FALSE), 11);
                }
                level.m_5594_(null, pos, sound1, SoundSource.BLOCKS, isNetherStove ? 1.5f : 1.0f, isNetherStove ? 0.5f : 1.5f);
                level.m_5594_(null, pos, sound2, SoundSource.BLOCKS, isNetherStove ? 1.0f : 1.5f, isNetherStove ? 0.5f : 1.0f);
                for (i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)particle1, (double)frontPos.m_123341_() + 0.5, (double)frontPos.m_123342_() + 0.5, (double)frontPos.m_123343_() + 0.5, MathUtils.RAND.nextGaussian() * 0.05, MathUtils.RAND.nextGaussian() * 0.05, MathUtils.RAND.nextGaussian() * 0.05);
                }
                for (i = 0; i < 4; ++i) {
                    level.m_7106_((ParticleOptions)particle2, (double)frontPos.m_123341_() + 0.5, (double)frontPos.m_123342_() + 0.5, (double)frontPos.m_123343_() + 0.5, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((tileEntity = level.m_7702_(pos)) instanceof NetherStoveBlockEntity) {
            NetherStoveBlockEntity stoveEntity = (NetherStoveBlockEntity)tileEntity;
            int stoveSlot = stoveEntity.getNextEmptySlot();
            if (stoveSlot < 0 || stoveEntity.isStoveBlockedAbove()) {
                return InteractionResult.PASS;
            }
            Optional<CampfireCookingRecipe> recipe = stoveEntity.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{heldStack}), stoveSlot);
            if (recipe.isPresent()) {
                if (!level.f_46443_ && stoveEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, recipe.get(), stoveSlot)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        boolean isNetherStove;
        boolean bl = isNetherStove = (Boolean)state.m_61143_((Property)SOUL) == false;
        if (isNetherStove) {
            return new ItemStack((ItemLike)MNDItems.NETHER_STOVE.get());
        }
        return new ItemStack((ItemLike)MNDItems.SOUL_NETHER_STOVE.get());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void extinguish(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f, false);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        boolean isSoul = (Boolean)level.m_8055_(pos).m_61143_((Property)SOUL);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            if (isSoul) {
                entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), 2.0f);
            } else {
                entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), 1.0f);
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof NetherStoveBlockEntity) {
                ItemUtils.dropItems((Level)worldIn, (BlockPos)pos, (IItemHandler)((NetherStoveBlockEntity)tileEntity).getInventory());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT, SOUL, FACING});
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            double zOffset;
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double horizontalOffset = rand.m_188500_() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
            double yOffset = rand.m_188500_() * 6.0 / 16.0;
            double d = zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
            if (((Boolean)stateIn.m_61143_((Property)SOUL)).booleanValue()) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MNDBlockEntityTypes.NETHER_STOVE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? NetherStoveBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)MNDBlockEntityTypes.NETHER_STOVE.get()), (BlockEntityTicker)(level.f_46443_ ? NetherStoveBlockEntity::animationTick : NetherStoveBlockEntity::cookingTick)) : null;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? BlockPathTypes.DAMAGE_FIRE : null;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

