/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.ZetaBushBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

public class GlowLichenGrowthBlock
extends ZetaBushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public GlowLichenGrowthBlock(@Nullable ZetaModule module) {
        super("glow_lichen_growth", module, CreativeModeTabs.f_256776_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152475_).m_60977_().m_60953_(s -> 8));
    }

    public void m_214162_(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_214162_(stateIn, worldIn, pos, rand);
        for (int i = 0; i < 10; ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (Math.random() - 0.5) * 5.0 + 0.5, (double)pos.m_123342_() + (Math.random() - 0.5) * 8.0 + 0.5, (double)pos.m_123343_() + (Math.random() - 0.5) * 5.0 + 0.5, 0.0, 0.0, 0.0);
        }
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (Math.random() - 0.5) * 0.4 + 0.5, (double)pos.m_123342_() + (Math.random() - 0.5) * 0.3 + 0.3, (double)pos.m_123343_() + (Math.random() - 0.5) * 0.4 + 0.5, 0.0, 0.0, 0.0);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return state.m_60783_(world, pos, Direction.UP);
    }

    public boolean m_7370_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState, boolean isClientSided) {
        for (Direction dir : MiscUtil.HORIZONTALS) {
            if (!this.canSpread((BlockGetter)levelReader, blockPos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    public boolean m_214167_(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        ArrayList list = Lists.newArrayList((Object[])MiscUtil.HORIZONTALS);
        Collections.shuffle(list);
        for (Direction dir : list) {
            BlockPos offPos = pos.m_121945_(dir);
            if (!this.canSpread((BlockGetter)world, offPos)) continue;
            world.m_7731_(offPos, state, 3);
            return;
        }
    }

    private boolean canSpread(BlockGetter world, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return world.m_8055_(pos).m_60795_() && this.m_6266_(world.m_8055_(below), world, below);
    }
}

