/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.stepped_lever;

import com.mangomilk.design_decor.blocks.stepped_lever.SteppedLeverBlockEntity;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlock;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Rotate;
import dev.engine_room.flywheel.lib.transform.Translate;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SteppedLeverVisual
extends AbstractBlockEntityVisual<SteppedLeverBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance handle = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDDPartialModels.STEPPED_LEVER_HANDLE)).createInstance();
    final float rX;
    final float rY;

    public SteppedLeverVisual(VisualizationContext context, SteppedLeverBlockEntity blockEntity, float partialTick) {
        super(context, (BlockEntity)blockEntity, partialTick);
        AttachFace face = (AttachFace)this.blockState.m_61143_((Property)AnalogLeverBlock.f_53179_);
        this.rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_((Property)AnalogLeverBlock.f_54117_)));
        this.animateLever(partialTick);
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (!((SteppedLeverBlockEntity)this.blockEntity).clientState.settled()) {
            this.animateLever(context.partialTick());
        }
    }

    private <T extends Translate<T> & Rotate<T>> T transform(T msr) {
        return (T)((Translate)((Rotate)((Translate)((Rotate)msr.translate((Vec3i)this.getVisualPosition()).center()).rotate((float)((double)(this.rY / 180.0f) * Math.PI), Direction.UP))).rotate((float)((double)(this.rX / 180.0f) * Math.PI), Direction.EAST)).uncenter();
    }

    protected void animateLever(float pt) {
        float state = ((SteppedLeverBlockEntity)this.blockEntity).clientState.getValue(pt);
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((TransformedInstance)this.transform(this.handle.setIdentityTransform()).translate(0.5f, 0.25f, 0.5f).rotate(angle, Direction.EAST)).translate(-0.5f, -0.25f, -0.5f).setChanged();
    }

    protected void _delete() {
        this.handle.delete();
    }

    public void updateLight(float v) {
        this.relight(new FlatLit[]{this.handle});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.handle);
    }
}

