/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.industrial_gear;

import com.mangomilk.design_decor.blocks.industrial_gear.IndustrialGearRenderer;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class IndustrialGearVisual {
    public static BlockEntityVisual<BracketedKineticBlockEntity> create(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
        if (ICogWheel.isLargeCog((BlockState)blockEntity.m_58900_())) {
            return new LargeIndustrialGearVisual(context, blockEntity, partialTick);
        }
        return new SingleAxisRotatingVisual(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)CDDPartialModels.COGWHEEL));
    }

    public static class LargeIndustrialGearVisual
    extends SingleAxisRotatingVisual<BracketedKineticBlockEntity> {
        protected RotatingInstance additionalShaft;

        public LargeIndustrialGearVisual(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
            super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)CDDPartialModels.SHAFTLESS_LARGE_COGWHEEL));
            Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
            this.additionalShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.COGWHEEL_SHAFT)).createInstance();
            this.additionalShaft.rotateToFace(axis).setup((KineticBlockEntity)blockEntity).setRotationOffset(IndustrialGearRenderer.getShaftAngleOffset(axis, this.pos)).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        }

        public void update(float pt) {
            super.update(pt);
            this.additionalShaft.setup((KineticBlockEntity)this.blockEntity).setRotationOffset(IndustrialGearRenderer.getShaftAngleOffset(this.rotationAxis(), this.pos)).setChanged();
        }

        public void updateLight(float partialTick) {
            super.updateLight(partialTick);
            this.relight(new FlatLit[]{this.additionalShaft});
        }

        protected void _delete() {
            super._delete();
            this.additionalShaft.delete();
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.additionalShaft);
        }
    }
}

