/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.chain;

import com.mangomilk.design_decor.registry.CDDSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TagDependentLargeChain
extends ChainBlock
implements SimpleWaterloggedBlock,
IWrenchable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final float AABB_MIN = 4.0f;
    protected static final float AABB_MAX = 12.0f;
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private TagKey<Item> tag;

    public TagDependentLargeChain(BlockBehaviour.Properties p_55926_, TagKey<Item> itemTagKey) {
        super(p_55926_.m_60910_().m_60955_().m_60960_(TagDependentLargeChain::never).m_60999_().m_60913_(5.0f, 6.0f).m_60918_((SoundType)new ForgeSoundType(1.0f, 0.95f, () -> (SoundEvent)CDDSoundEvents.LARGE_CHAIN_BREAK.get(), () -> (SoundEvent)CDDSoundEvents.LARGE_CHAIN_STEP.get(), () -> (SoundEvent)CDDSoundEvents.LARGE_CHAIN_PLACE.get(), () -> (SoundEvent)CDDSoundEvents.LARGE_CHAIN_HIT.get(), () -> (SoundEvent)CDDSoundEvents.LARGE_CHAIN_FALL.get())));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y));
        this.tag = itemTagKey;
    }

    public VoxelShape m_5940_(BlockState p_51470_, BlockGetter p_51471_, BlockPos p_51472_, CollisionContext p_51473_) {
        switch ((Direction.Axis)p_51470_.m_61143_((Property)f_55923_)) {
            default: {
                return X_AXIS_AABB;
            }
            case Z: {
                return Z_AXIS_AABB;
            }
            case Y: 
        }
        return Y_AXIS_AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_51454_) {
        FluidState fluidstate = p_51454_.m_43725_().m_6425_(p_51454_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(p_51454_)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.m_186469_(p_51465_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51464_));
        }
        return super.m_7417_(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51468_) {
        p_51468_.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{f_55923_});
    }

    public FluidState m_5888_(BlockState p_51475_) {
        return (Boolean)p_51475_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51475_);
    }

    public boolean m_7357_(BlockState p_51456_, BlockGetter p_51457_, BlockPos p_51458_, PathComputationType p_51459_) {
        return false;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)itemInHand.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public static BlockState pickCorrectLargeChain(BlockState stateForPlacement, Level level, BlockPos pos) {
        return stateForPlacement;
    }

    private static boolean never(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    public boolean shouldHide() {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        return !tagManager.isKnownTagName(this.tag) || tagManager.getTag(this.tag).isEmpty();
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof TagDependentLargeChain, state -> (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_), (Property)RotatedPillarBlock.f_55923_);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof TagDependentLargeChain;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof TagDependentLargeChain;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> TagDependentLargeChain.pickCorrectLargeChain(s, world, offset.getBlockPos())));
            }
            return offset;
        }
    }
}

