/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.ceiling_fan;

import com.mangomilk.design_decor.blocks.ceiling_fan.CeilingFanBlockEntity;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CeilingFanRenderer
extends KineticBlockEntityRenderer<CeilingFanBlockEntity> {
    public CeilingFanRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CeilingFanBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        BlockState blockState = be.m_58900_();
        float speed = be.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = be.angle + speed * partialTicks;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        this.renderFlywheel(be, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(CeilingFanBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer fan = CachedBuffers.partial((PartialModel)CDDPartialModels.CEILING_FAN, (BlockState)blockState);
        CeilingFanRenderer.kineticRotationTransform((SuperByteBuffer)fan, (KineticBlockEntity)be, (Direction.Axis)CeilingFanRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        fan.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(CeilingFanBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)Direction.UP);
    }

    protected BlockState getRenderedBlockState(CeilingFanBlockEntity be) {
        return CeilingFanRenderer.shaft((Direction.Axis)CeilingFanRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

