/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.leaks.common.mods.forge;

import com.google.common.base.Stopwatch;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;

@Issue(modId="forge", versionRange="[47.2,)", description="Regenerate listeners cache on server stopped")
public class UntrackedIssue003 {
    public static final MethodHandle GET_LISTENERS;
    public static final VarHandle ALL_LISTS;
    public static final VarHandle LISTS;
    public static final Class<?> LISTENER_LIST_INST_CLASS;

    public UntrackedIssue003() {
        IEventBus gameBus = MinecraftForge.EVENT_BUS;
        gameBus.addListener(EventPriority.LOWEST, this::rebuildListenersCache);
    }

    private void rebuildListenersCache(ServerStoppedEvent event) {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            List listeners = ALL_LISTS.get();
            for (ListenerList listener : listeners) {
                Object[] list;
                for (Object ev : list = LISTS.get(listener)) {
                    GET_LISTENERS.invoke(ev);
                }
            }
            AllTheLeaks.LOGGER.debug("Rebuild listeners cache took {}ms", (Object)watch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Throwable e) {
            AllTheLeaks.LOGGER.error("Error while trying to rebuild listeners cache", e);
        }
    }

    static {
        ALL_LISTS = ReflectionHelper.getFieldFromClass(ListenerList.class, "allLists", List.class, true);
        LISTENER_LIST_INST_CLASS = ReflectionHelper.getPrivateClass(ListenerList.class, "net.minecraftforge.eventbus.ListenerList$ListenerListInst");
        GET_LISTENERS = ReflectionHelper.getMethodFromClass(LISTENER_LIST_INST_CLASS, "getListeners", MethodType.methodType(IEventListener.class.arrayType()), false);
        LISTS = ReflectionHelper.getFieldFromClass(ListenerList.class, "lists", LISTENER_LIST_INST_CLASS.arrayType(), false);
    }
}

