/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.commands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.mixin.Trackable;
import dev.uncandango.alltheleaks.mixin.core.main.IngredientMixin;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fml.ModList;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.slf4j.Logger;

public final class ATLCommands {
    public static void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"atl").then(Commands.m_82127_((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_ingredient_duplicates").requires(source -> AllTheLeaks.INDEV)).executes(cmd -> ATLCommands.dumpIngredientDuplicates((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.m_82127_((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    private static int doModernFixThreadDump(CommandSourceStack source) {
        AllTheLeaks.LOGGER.error(ThreadDumper.obtainThreadDump());
        source.m_243053_((Component)Component.m_237113_((String)"Thread dump done, check latest.log"));
        return 1;
    }

    private static int resetStatistics(CommandSourceStack source) {
        ATLCommands.runGc(source);
        MemoryMonitor.Statistics.reset();
        return 1;
    }

    public static void registerServerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"atl").then(Commands.m_82127_((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.m_82127_((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    public static int checkLeaking(CommandSourceStack source, boolean shouldRunGc) {
        if (shouldRunGc && ATLCommands.runGc(source) == 0) {
            return 0;
        }
        Trackable.clearNullReferences();
        AllTheLeaks.LOGGER.info("Logging events from checking leak");
        MemoryMonitor.getEventsSummary().forEach(arg_0 -> ((Logger)AllTheLeaks.LOGGER).info(arg_0));
        ArrayList lines = new ArrayList();
        Trackable.getSummary().forEach((baseClazz, summaryMap) -> {
            if (summaryMap.isEmpty()) {
                return;
            }
            lines.add(Component.m_237110_((String)"%s:", (Object[])new Object[]{baseClazz.getSimpleName()}));
            summaryMap.forEach((innerClazz, count) -> {
                Module module = innerClazz.getModule();
                if (module != null) {
                    lines.add(Component.m_237110_((String)"- %s (%s): %s", (Object[])new Object[]{innerClazz.getSimpleName(), module.getName(), count}));
                } else {
                    lines.add(Component.m_237110_((String)"- %s: %s", (Object[])new Object[]{innerClazz.getSimpleName(), count}));
                }
            });
        });
        if (lines.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"No leak was found so far...").m_130940_(ChatFormatting.GREEN));
        } else {
            source.m_243053_((Component)Component.m_237113_((String)"Listing leaks...").m_130940_(ChatFormatting.YELLOW));
            lines.forEach(arg_0 -> ((CommandSourceStack)source).m_243053_(arg_0));
        }
        return 1;
    }

    public static int runGc(CommandSourceStack source) {
        if (!MemoryMonitor.runExplicitGc()) {
            source.m_81352_((Component)Component.m_237113_((String)"Explicit GC is disabled, remove arguments -XX:+DisableExplicitGC"));
            return 0;
        }
        return 1;
    }

    public static int dumpIngredientDuplicates(CommandSourceStack source) {
        HashMultimap recipeJsonToIngredientMap = HashMultimap.create();
        source.getRecipeManager().m_44051_().forEach(arg_0 -> ATLCommands.lambda$dumpIngredientDuplicates$14((Multimap)recipeJsonToIngredientMap, arg_0));
        recipeJsonToIngredientMap.asMap().forEach((key, value) -> {
            HashSet innerIngredientSet = new HashSet();
            value.forEach(pair -> innerIngredientSet.add((Ingredient)pair.getFirst()));
            if (innerIngredientSet.size() > 1) {
                AllTheLeaks.LOGGER.warn("Ingredients with the same json: {}", key);
                innerIngredientSet.forEach(ingredient -> {
                    AllTheLeaks.LOGGER.warn("  - {}", ingredient);
                    if (ingredient.isVanilla() && ingredient instanceof IngredientMixin.IngredientAccessor) {
                        IngredientMixin.IngredientAccessor accessor = (IngredientMixin.IngredientAccessor)ingredient;
                        for (Ingredient.Value ivalue : accessor.getValues()) {
                            if (ivalue instanceof IngredientMixin.ItemValueAccessor) {
                                IngredientMixin.ItemValueAccessor iv = (IngredientMixin.ItemValueAccessor)ivalue;
                                ItemStack is = iv.getItem();
                                AllTheLeaks.LOGGER.warn("    - {} - {}", (Object)((ResourceKey)is.m_220173_().m_203543_().get()).m_135782_(), (Object)is.m_41783_());
                            }
                            if (!(ivalue instanceof Ingredient.TagValue)) continue;
                            Ingredient.TagValue tv = (Ingredient.TagValue)ivalue;
                            AllTheLeaks.LOGGER.warn("    - {}", (Object)tv.m_6544_());
                        }
                    }
                });
            }
        });
        return 1;
    }

    private static /* synthetic */ void lambda$dumpIngredientDuplicates$14(Multimap recipeJsonToIngredientMap, Recipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            JsonElement jsonElement = ingredient.m_43942_();
            ResourceLocation recipeId = recipe.m_6423_();
            Pair key = Pair.of((Object)ingredient, (Object)recipeId);
            recipeJsonToIngredientMap.put((Object)jsonElement, (Object)key);
        }
    }
}

