/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.network;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkManager {
    protected final SimpleChannel channel;

    public NetworkManager(ResourceLocation name, String version) {
        if (name == null || version == null) {
            throw new IllegalArgumentException();
        }
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> version, version::equals, version::equals);
    }

    public NetworkManager(ResourceLocation name, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        if (name == null || networkProtocolVersion == null || clientAcceptedVersions == null || serverAcceptedVersions == null) {
            throw new IllegalArgumentException();
        }
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, networkProtocolVersion, clientAcceptedVersions, serverAcceptedVersions);
    }

    public <T extends NetworkPacket> void registerPacket(int discriminator, Class<T> packetClass, Supplier<T> packetSupplier) {
        if (packetClass == null || packetSupplier == null || packetSupplier.get() == null) {
            throw new IllegalArgumentException();
        }
        this.channel.registerMessage(discriminator, packetClass, (p, b) -> p.writeToBuffer((FriendlyByteBuf)b), b -> {
            NetworkPacket p = (NetworkPacket)packetSupplier.get();
            p.readFromBuffer((FriendlyByteBuf)b);
            return p;
        }, (p, s) -> {
            switch (((NetworkEvent.Context)s.get()).getDirection().getReceptionSide()) {
                case CLIENT: {
                    p.handlePacketClient((NetworkEvent.Context)s.get());
                    ((NetworkEvent.Context)s.get()).setPacketHandled(true);
                    break;
                }
                case SERVER: {
                    p.handlePacketServer((NetworkEvent.Context)s.get());
                    ((NetworkEvent.Context)s.get()).setPacketHandled(true);
                    break;
                }
            }
        });
    }

    public <T extends NetworkPacket> void send(T packet, PacketDistributor.PacketTarget target) {
        if (packet == null || target == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(target, packet);
    }

    public <T extends NetworkPacket> void sendTo(T packet, ServerPlayer player) {
        if (packet == null || player == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public <T extends NetworkPacket> void sendToAll(T packet) {
        if (packet == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(PacketDistributor.ALL.noArg(), packet);
    }

    public <T extends NetworkPacket> void sendToAllAround(T packet, PacketDistributor.TargetPoint point) {
        if (packet == null || point == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(PacketDistributor.NEAR.with(() -> point), packet);
    }

    public <T extends NetworkPacket> void sendToDimension(T packet, ResourceKey<Level> dimension) {
        if (packet == null || dimension == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), packet);
    }

    public <T extends NetworkPacket> void sendToServer(T packet) {
        if (packet == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public static interface NetworkPacket {
        public void handlePacketClient(NetworkEvent.Context var1);

        public void handlePacketServer(NetworkEvent.Context var1);

        public void readFromBuffer(FriendlyByteBuf var1);

        public void writeToBuffer(FriendlyByteBuf var1);
    }
}

