/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.basin_lid;

import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.basin_lid.BasinFermentingRecipe;
import com.jesz.createdieselgenerators.content.basin_lid.BasinLidBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BasinLidBlockEntity
extends BasinOperatingBlockEntity {
    public int processingTime;
    public boolean running;
    public float progress;
    public boolean steamInside = false;
    private static final Object basinFermentingRecipesKey = new Object();

    public BasinLidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("ProcessingTime", this.processingTime);
        compound.m_128379_("Running", this.running);
        compound.m_128379_("SteamInside", this.steamInside);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTime = compound.m_128451_("ProcessingTime");
        this.running = compound.m_128471_("Running");
        this.steamInside = compound.m_128471_("SteamInside");
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.processingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (this.currentRecipe != null) {
            this.progress = (float)this.processingTime / (float)((BasinFermentingRecipe)this.currentRecipe).getProcessingDuration();
        } else {
            if (this.processingTime != -1) {
                List recipes = this.getMatchingRecipes();
                if (!recipes.isEmpty()) {
                    this.currentRecipe = (Recipe)recipes.get(0);
                } else {
                    this.processingTime = -1;
                }
            }
            this.progress = 0.0f;
        }
        if (!this.f_58857_.f_46443_ && (this.currentRecipe == null || this.processingTime == -1) || ((Boolean)this.m_58900_().m_61143_((Property)BasinLidBlock.OPEN)).booleanValue() || !((Boolean)this.m_58900_().m_61143_((Property)BasinLidBlock.ON_A_BASIN)).booleanValue()) {
            this.running = false;
            this.processingTime = -1;
            this.basinChecker.scheduleUpdate();
        }
        if (this.running) {
            this.steamInside = true;
        }
        if (this.running && this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_ && this.processingTime <= 0) {
                this.processingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (!this.f_58857_.f_46443_ && this.processingTime % 20 == 0 && new Random().nextInt() % 4 == 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.15f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime == 1) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11772_, SoundSource.BLOCKS, 0.15f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime > 0) {
                --this.processingTime;
            }
        }
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.f_58857_ == null) {
            return true;
        }
        if (this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.processingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)recipe;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.processingTime = n;
    }

    public ProcessingRecipe<?> getRecipe() {
        ProcessingRecipe processed;
        Recipe recipe = this.currentRecipe;
        return recipe instanceof ProcessingRecipe ? (processed = (ProcessingRecipe)recipe) : null;
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.f_58857_.m_7702_(this.f_58858_.m_6625_(1));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BasinLidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == CDGRecipes.BASIN_FERMENTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return basinFermentingRecipesKey;
    }
}

