/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.infrastructure.ponder.scenes;

import com.negodya1.vintageimprovements.VintageItems;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CentrifugeScenes {
    public static void processing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("centrifuge", "Processing Items in the Centrifuge");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos centrifuge = util.grid().at(2, 1, 2);
        Selection centrifugeSelect = util.select().position(2, 1, 2);
        scene.world().setKineticSpeed(centrifugeSelect, 0.0f);
        scene.world().showSection(util.select().position(centrifuge), Direction.DOWN);
        scene.idle(10);
        Vec3 centrifugeTop = util.vector().topOf(centrifuge);
        scene.overlay().showText(40).attachKeyFrame().text("Centrifuge can process a variety of items").pointAt(centrifugeTop).placeNearTarget();
        scene.idle(50);
        scene.overlay().showText(90).attachKeyFrame().text("Before work you must install 4 Basins on Centrifuge").pointAt(centrifugeTop).placeNearTarget();
        scene.idle(10);
        ItemStack basin = new ItemStack((ItemLike)AllBlocks.BASIN.m_5456_());
        for (int i = 0; i < 4; ++i) {
            scene.overlay().showControls(util.vector().blockSurface(centrifuge, Direction.NORTH), Pointing.RIGHT, 50);
            scene.idle(8);
            scene.world().modifyBlockEntity(centrifuge, CentrifugeBlockEntity.class, ms -> ms.addBasin(basin.m_41777_()));
            scene.idle(12);
        }
        Selection cogs = util.select().fromTo(2, 2, 2, 5, 3, 2);
        scene.world().setBlock(centrifuge.m_7494_(), (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), false);
        scene.world().setKineticSpeed(util.select().position(centrifuge.m_7494_()), 100.0f);
        scene.world().showSection(cogs, Direction.DOWN);
        scene.world().showSection(util.select().position(5, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(centrifugeSelect, 100.0f);
        scene.effects().indicateSuccess(centrifuge);
        scene.idle(10);
        scene.overlay().showText(40).attachKeyFrame().colored(PonderPalette.GREEN).text("They can be powered from the up or down using shafts").pointAt(util.vector().topOf(centrifuge.m_7494_())).placeNearTarget();
        scene.idle(50);
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42545_);
        Vec3 entitySpawn = util.vector().topOf(centrifuge.m_122012_().m_6630_(3));
        ElementLink entity1 = scene.world().createItemEntity(entitySpawn, util.vector().of(0.0, 0.2, 0.0), itemStack);
        scene.idle(28);
        scene.overlay().showText(40).attachKeyFrame().text("Items and Fluids \u0441an only be inserted when Centrifuge is stopped").pointAt(centrifuge.m_122012_().m_252807_()).placeNearTarget();
        scene.idle(50);
        scene.world().modifyEntity(entity1, Entity::m_146870_);
        scene.idle(10);
        scene.world().setBlock(centrifuge.m_7494_(), (BlockState)AllBlocks.CLUTCH.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), false);
        BlockPos lever = centrifuge.m_7494_().m_122012_();
        Selection leverSelect = util.select().position(lever);
        Selection clutchSelect = util.select().position(lever.m_122019_());
        scene.world().showSection(leverSelect, Direction.DOWN);
        scene.idle(10);
        scene.world().replaceBlocks(leverSelect, (BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true)), false);
        scene.world().replaceBlocks(clutchSelect, (BlockState)((BlockState)AllBlocks.CLUTCH.getDefaultState().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), false);
        scene.world().setKineticSpeed(centrifugeSelect, 0.0f);
        scene.idle(10);
        ElementLink entity2 = scene.world().createItemEntity(entitySpawn, util.vector().of(0.0, 0.2, 0.0), itemStack);
        scene.idle(18);
        scene.world().modifyEntity(entity2, Entity::m_146870_);
        scene.world().modifyBlockEntity(centrifuge, CentrifugeBlockEntity.class, ms -> ms.inputInv.setStackInSlot(0, itemStack));
        scene.idle(10);
        scene.overlay().showControls(centrifugeTop, Pointing.DOWN, 30);
        scene.idle(7);
        scene.world().replaceBlocks(leverSelect, (BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(false)), false);
        scene.world().replaceBlocks(clutchSelect, (BlockState)((BlockState)AllBlocks.CLUTCH.getDefaultState().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), false);
        scene.world().setKineticSpeed(centrifugeSelect, 100.0f);
        scene.idle(10);
        scene.overlay().showText(40).attachKeyFrame().text("The result can be extracted via Right-click or automatization...").pointAt(centrifuge.m_122012_().m_252807_()).placeNearTarget();
        scene.idle(50);
        scene.overlay().showText(40).attachKeyFrame().text("...but only when Centrifuge is stopped").pointAt(centrifuge.m_122012_().m_252807_()).placeNearTarget();
        scene.idle(10);
        scene.world().replaceBlocks(leverSelect, (BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true)), false);
        scene.world().replaceBlocks(clutchSelect, (BlockState)((BlockState)AllBlocks.CLUTCH.getDefaultState().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), false);
        scene.world().setKineticSpeed(centrifugeSelect, 0.0f);
        scene.idle(10);
        ItemStack pearl = new ItemStack((ItemLike)Items.f_42584_);
        scene.world().showSection(util.select().position(0, 1, 1), Direction.DOWN);
        scene.world().modifyBlockEntity(centrifuge, CentrifugeBlockEntity.class, ms -> ms.inputInv.setStackInSlot(0, ItemStack.f_41583_));
        scene.world().createItemEntity(util.grid().at(0, 1, 1).m_252807_(), new Vec3(0.0, 0.2, 0.0), pearl);
        scene.idle(15);
        scene.world().showSection(util.select().fromTo(1, 4, 2, 2, 4, 3), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(1, 2, 2, 1, 3, 3), Direction.DOWN);
        scene.idle(16);
        scene.markAsFinished();
        scene.idle(25);
        scene.world().modifyEntities(ItemEntity.class, Entity::m_146870_);
    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("centrifuge_redstone", "Centrifuge Comparator interaction");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos centrifuge = util.grid().at(2, 1, 2);
        Selection centrifugeSelect = util.select().position(2, 1, 2);
        scene.world().setKineticSpeed(centrifugeSelect, 0.0f);
        scene.world().showSection(util.select().fromTo(0, 1, 0, 4, 1, 4), Direction.DOWN);
        scene.idle(10);
        Vec3 centrifugeTop = util.vector().topOf(centrifuge);
        scene.overlay().showText(40).attachKeyFrame().text("Centrifuge can produce Comparator signal").pointAt(centrifugeTop).placeNearTarget();
        scene.idle(50);
        scene.overlay().showText(50).attachKeyFrame().text("You must install Redstone Module into the Centrifuge").pointAt(centrifugeTop).placeNearTarget();
        scene.idle(10);
        ItemStack module = new ItemStack((ItemLike)VintageItems.REDSTONE_MODULE.get());
        scene.overlay().showControls(util.vector().blockSurface(centrifuge, Direction.NORTH), Pointing.RIGHT, 30).rightClick().withItem(module);
        scene.world().modifyBlockEntity(centrifuge, CentrifugeBlockEntity.class, ms -> ms.addRedstoneApp(module.m_41777_()));
        scene.idle(30);
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42542_);
        Vec3 entitySpawn = util.vector().topOf(centrifuge.m_122012_().m_6630_(3));
        ElementLink entity2 = scene.world().createItemEntity(entitySpawn, util.vector().of(0.0, 0.2, 0.0), itemStack);
        scene.idle(18);
        scene.world().modifyEntity(entity2, Entity::m_146870_);
        scene.world().replaceBlocks(util.select().position(0, 1, 1), (BlockState)((BlockState)Blocks.f_50328_.m_49966_().m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST), false);
        scene.overlay().showText(60).attachKeyFrame().text("Centrifuge will produce a level 15 redstone signal as long as it has a recipe").pointAt(new Vec3(0.0, 1.0, 1.0)).placeNearTarget();
        scene.idle(70);
        scene.markAsFinished();
        scene.idle(25);
        scene.world().modifyEntities(ItemEntity.class, Entity::m_146870_);
    }
}

