/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.vibration;

import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.VintageRecipesList;
import com.negodya1.vintageimprovements.content.kinetics.vibration.VibratingRecipe;
import com.negodya1.vintageimprovements.content.kinetics.vibration.VibratingTableBlock;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancementBehaviour;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancements;
import com.negodya1.vintageimprovements.infrastructure.config.VintageConfig;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VibratingTableBlockEntity
extends KineticBlockEntity {
    public SmartInventory inputInv = new SmartInventory(1, (SyncedBlockEntity)this);
    public SmartInventory outputInv = new SmartInventory(9, (SyncedBlockEntity)this);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new VibratingTableInventoryHandler());
    public int timer;
    private VibratingRecipe lastRecipe;
    private ItemStack playEvent = ItemStack.f_41583_;
    boolean lastRecipeIsAssembly;
    VintageAdvancementBehaviour advancementBehaviour;
    public static final TagKey<Item> storageTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "storage_blocks"));
    public static final TagKey<Item> leavesTag = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft", "leaves"));

    public VibratingTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        return partialTicks * 3.0f / 16.0f;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        compound.m_128379_("LastRecipeIsAssembly", this.lastRecipeIsAssembly);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.m_41619_()) {
            return;
        }
        compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
        this.playEvent = ItemStack.f_41583_;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        this.lastRecipeIsAssembly = compound.m_128471_("LastRecipeIsAssembly");
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.m_41619_()) {
            this.playEvent = ItemStack.f_41583_;
            AllSoundEvents.SANDING_SHORT.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
        }
    }

    public void spawnParticles() {
        if (!this.haveRecipe()) {
            return;
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.m_41619_()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, stackInSlot);
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_((ParticleOptions)data, center.f_82479_, center.f_82480_ + 0.5 + (double)this.getRenderedHeadOffset(Minecraft.m_91087_().getPartialTick()), center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.f_58857_.f_46443_) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (Container)inventoryIn, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
            if (assemblyRecipe.isPresent()) {
                this.lastRecipe = (VibratingRecipe)((Object)assemblyRecipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
                if (this.timer == 0) {
                    this.timer = 100;
                }
                this.lastRecipeIsAssembly = true;
                this.sendData();
                return;
            }
            this.lastRecipeIsAssembly = false;
            Optional recipe = VintageRecipes.VIBRATING.find(inventoryIn, this.f_58857_);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (VibratingRecipe)((Object)recipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        if (this.timer == 0) {
            this.timer = 100;
        }
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean haveRecipe() {
        return this.canProcess(this.inputInv.getStackInSlot(0));
    }

    public static <C extends Container> boolean canUnpack(Recipe<C> recipe) {
        if (!(recipe instanceof CraftingRecipe) || !((Boolean)VintageConfig.server().recipes.allowUnpackingOnVibratingTable.get()).booleanValue()) {
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        if (ingredients.size() == 1) {
            return ((Ingredient)ingredients.get(0)).m_43908_()[0].m_204117_(storageTag);
        }
        return false;
    }

    private boolean canProcess(ItemStack stack) {
        if (Mth.m_14154_((float)this.getSpeed()) < IRotate.SpeedLevel.FAST.getSpeedValue()) {
            return false;
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)stack, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            return true;
        }
        if (VintageRecipes.VIBRATING.find(inventoryIn, this.f_58857_).isPresent()) {
            return true;
        }
        if (((Boolean)VintageConfig.server().recipes.allowVibratingLeaves.get()).booleanValue() && VintageRecipes.LEAVES_VIBRATING.find(inventoryIn, this.f_58857_).isPresent()) {
            return true;
        }
        return tester.getStackInSlot(0).m_204117_(storageTag) && (Boolean)VintageConfig.server().recipes.allowUnpackingOnVibratingTable.get() != false;
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional recipe;
            boolean found = false;
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (Container)inventoryIn, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
            if (assemblyRecipe.isPresent()) {
                this.lastRecipe = (VibratingRecipe)((Object)assemblyRecipe.get());
                found = true;
            }
            if (!found && (recipe = VintageRecipes.VIBRATING.find(inventoryIn, this.f_58857_)).isPresent()) {
                this.lastRecipe = (VibratingRecipe)((Object)recipe.get());
                found = true;
            }
            if (!found && ((Boolean)VintageConfig.server().recipes.allowUnpackingOnVibratingTable.get()).booleanValue() && this.inputInv.getStackInSlot(0).m_204117_(storageTag)) {
                List<CraftingRecipe> recipes = VintageRecipesList.getUnpacking();
                for (CraftingRecipe recipe2 : recipes) {
                    if (recipe2.m_7527_().size() > 1) continue;
                    NonNullList in = recipe2.m_7527_();
                    for (Ingredient i : in) {
                        for (ItemStack stack2 : i.m_43908_()) {
                            Item ingredient = stack2.m_41720_();
                            if (ingredient != this.inputInv.getStackInSlot(0).m_41720_()) continue;
                            ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
                            stackInSlot.m_41774_(1);
                            this.inputInv.setStackInSlot(0, stackInSlot);
                            ItemStack result = recipe2.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
                            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
                            this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_VIBRATION_TABLE);
                            this.sendData();
                            this.m_6596_();
                            return;
                        }
                    }
                }
            }
            if (!found && ((Boolean)VintageConfig.server().recipes.allowVibratingLeaves.get()).booleanValue() && this.inputInv.getStackInSlot(0).m_204117_(leavesTag)) {
                ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
                if (stackInSlot.m_41720_() instanceof BlockItem) {
                    Block leaves = Block.m_49814_((Item)stackInSlot.m_41720_());
                    ItemStack hoe = Items.f_42392_.m_7968_();
                    hoe.m_41663_(Enchantments.f_44987_, 3);
                    List list = Block.m_49874_((BlockState)leaves.m_49966_(), (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, null, null, (ItemStack)hoe.m_41777_());
                    for (ItemStack result : list) {
                        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
                    }
                }
                stackInSlot.m_41774_(1);
                this.inputInv.setStackInSlot(0, stackInSlot);
                this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_VIBRATION_TABLE);
                this.sendData();
                this.m_6596_();
                return;
            }
            if (!found) {
                return;
            }
        }
        if (this.lastRecipeIsAssembly) {
            VibratingRecipe.apply(this, this.lastRecipe);
            this.lastRecipe = null;
        } else {
            ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
            stackInSlot.m_41774_(1);
            this.inputInv.setStackInSlot(0, stackInSlot);
            this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        }
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_VIBRATION_TABLE);
        this.sendData();
        this.m_6596_();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, boolean simulate) {
        this.outputInv.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, simulate);
        this.outputInv.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof VibratingTableBlock)) {
            return false;
        }
        SmartInventory targetInv = this.outputInv;
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        return this.acceptItemOutputsIntoHelve(outputItems, simulate, (IItemHandler)targetInv);
    }

    private boolean acceptItemOutputsIntoHelve(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private class VibratingTableInventoryHandler
    extends CombinedInvWrapper {
        public VibratingTableInventoryHandler() {
            super(new IItemHandlerModifiable[]{VibratingTableBlockEntity.this.inputInv, VibratingTableBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (VibratingTableBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return VibratingTableBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (VibratingTableBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (VibratingTableBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

