/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.lathe.recipe_card;

import com.negodya1.vintageimprovements.VintageMenuTypes;
import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.content.kinetics.lathe.TurningRecipe;
import com.negodya1.vintageimprovements.content.kinetics.lathe.recipe_card.RecipeCardItem;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class RecipeCardMenu
extends GhostItemMenu<ItemStack> {
    private static final Object turningRecipesKey = new Object();
    private final Level level;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    List<TurningRecipe> recipes;
    public ItemStackHandler resultInventory;

    public RecipeCardMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
        this.level = inv.f_35978_.m_9236_();
        this.selectedRecipeIndex.m_6422_(RecipeCardItem.getIndex((ItemStack)this.contentHolder));
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_()) && this.getRecipes().get(this.selectedRecipeIndex.m_6501_()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(this.resultInventory.getStackInSlot(0).m_41720_())) {
            for (int i = 0; i < this.getRecipes().size(); ++i) {
                if (!this.getRecipes().get(i).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(this.resultInventory.getStackInSlot(0).m_41720_())) continue;
                this.selectedRecipeIndex.m_6422_(i);
                break;
            }
        }
        this.m_38895_(this.selectedRecipeIndex);
        this.recipes = new ArrayList<TurningRecipe>();
    }

    public RecipeCardMenu(MenuType<?> type, int id, Inventory inv, ItemStack filterItem) {
        super(type, id, inv, (Object)filterItem);
        this.level = inv.f_35978_.m_9236_();
        this.selectedRecipeIndex.m_6422_(RecipeCardItem.getIndex((ItemStack)this.contentHolder));
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_()) && !this.getRecipes().get(this.selectedRecipeIndex.m_6501_()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(this.resultInventory.getStackInSlot(0).m_41720_())) {
            for (int i = 0; i < this.getRecipes().size(); ++i) {
                if (!this.getRecipes().get(i).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(this.resultInventory.getStackInSlot(0).m_41720_())) continue;
                this.selectedRecipeIndex.m_6422_(i);
                break;
            }
        }
        this.m_38895_(this.selectedRecipeIndex);
        this.recipes = new ArrayList<TurningRecipe>();
    }

    public static RecipeCardMenu create(int id, Inventory inv, ItemStack filterItem) {
        return new RecipeCardMenu((MenuType)VintageMenuTypes.RECIPE_CARD.get(), id, inv, filterItem);
    }

    protected void initAndReadInventory(ItemStack contentHolder) {
        super.initAndReadInventory((Object)contentHolder);
        this.resultInventory = this.createResultInventory();
    }

    protected ItemStack createOnClient(FriendlyByteBuf extraData) {
        return extraData.m_130267_();
    }

    protected ItemStackHandler createGhostInventory() {
        return RecipeCardItem.getFrequencyItems((ItemStack)this.contentHolder);
    }

    protected ItemStackHandler createResultInventory() {
        return RecipeCardItem.getResultItems((ItemStack)this.contentHolder);
    }

    protected void addSlots() {
        this.addPlayerSlots(8, 131);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 23, 51));
    }

    protected void saveData(ItemStack contentHolder) {
        contentHolder.m_41784_().m_128365_("Items", (Tag)this.ghostInventory.serializeNBT());
        contentHolder.m_41784_().m_128365_("Results", (Tag)this.resultInventory.serializeNBT());
        contentHolder.m_41698_("Recipe").m_128405_("Index", this.selectedRecipeIndex.m_6501_());
    }

    protected boolean allowRepeats() {
        return false;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == this.playerInventory.f_35977_ && clickTypeIn != ClickType.THROW) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_6875_(Player playerIn) {
        return this.playerInventory.m_36056_() == this.contentHolder;
    }

    private void setupRecipeList() {
        if (this.recipes != null) {
            this.recipes.clear();
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)this.ghostInventory.getStackInSlot(0), VintageRecipes.TURNING.getType(), TurningRecipe.class);
        List<TurningRecipe> startedSearch = new ArrayList<TurningRecipe>();
        if (assemblyRecipe.isPresent()) {
            startedSearch.add((TurningRecipe)((Object)assemblyRecipe.get()));
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{VintageRecipes.TURNING.getType()});
        for (Recipe recipe : RecipeFinder.get((Object)turningRecipesKey, (Level)this.level, (Predicate)types)) {
            if (!(recipe instanceof TurningRecipe)) continue;
            TurningRecipe turningRecipe = (TurningRecipe)recipe;
            startedSearch.add(turningRecipe);
        }
        startedSearch = startedSearch.stream().filter(RecipeConditions.firstIngredientMatches((ItemStack)this.ghostInventory.getStackInSlot(0))).filter(r -> !VintageRecipes.shouldIgnoreInAutomation(r)).sorted(Comparator.comparing(r -> r.m_8043_(this.level.m_9598_()).m_41778_())).collect(Collectors.toList());
        this.recipes = startedSearch;
    }

    public List<TurningRecipe> getRecipes() {
        if (this.recipes != null && !this.recipes.isEmpty() && ((Ingredient)this.recipes.get(0).m_7527_().get(0)).test(this.ghostInventory.getStackInSlot(0))) {
            return this.recipes;
        }
        this.setupRecipeList();
        return this.recipes;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public boolean m_6366_(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.resultInventory.setSize(1);
            this.resultInventory.setStackInSlot(0, this.getRecipes().get(index).m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.getRecipes().size();
    }

    public void clearContents() {
        super.clearContents();
        this.selectedRecipeIndex.m_6422_(-1);
        this.recipes.clear();
        for (int i = 0; i < this.resultInventory.getSlots(); ++i) {
            this.resultInventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

