/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.lathe;

import com.negodya1.vintageimprovements.VintageLang;
import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.content.kinetics.lathe.LatheMovingBlockEntity;
import com.negodya1.vintageimprovements.content.kinetics.lathe.LatheRotatingBlock;
import com.negodya1.vintageimprovements.content.kinetics.lathe.TurningRecipe;
import com.negodya1.vintageimprovements.content.kinetics.lathe.recipe_card.RecipeCardItem;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancementBehaviour;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancements;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LatheRotatingBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private static final Object turningRecipesKey = new Object();
    public SmartInventory inputInv = new SmartInventory(1, (SyncedBlockEntity)this, 1, false);
    public SmartInventory outputInv = new SmartInventory(1, (SyncedBlockEntity)this);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new LatheInventoryHandler());
    public float timer;
    public float initialTimer;
    private TurningRecipe lastRecipe;
    private ItemStack playEvent = ItemStack.f_41583_;
    public VintageAdvancementBehaviour advancementBehaviour;

    public LatheRotatingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void resetRecipe() {
        this.lastRecipe = null;
        this.timer = 0.0f;
        this.initialTimer = 0.0f;
    }

    public float getRenderedHeadOffset() {
        if (this.inputInv.m_7983_() || this.timer <= 0.0f) {
            return 0.0f;
        }
        if (this.timer < 10.0f) {
            return this.timer / 3.0f / 16.0f;
        }
        if (this.initialTimer - this.timer < 10.0f) {
            return (this.initialTimer - this.timer) / 3.0f / 16.0f;
        }
        return (4.0f + Mth.m_14031_((float)(this.timer / 4.0f)) * 2.0f) / 16.0f;
    }

    public List<TurningRecipe> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inputInv.getStackInSlot(0), VintageRecipes.TURNING.getType(), TurningRecipe.class);
        ArrayList<TurningRecipe> startedSearch = new ArrayList<TurningRecipe>();
        if (assemblyRecipe.isPresent()) {
            startedSearch.add((TurningRecipe)((Object)assemblyRecipe.get()));
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{VintageRecipes.TURNING.getType()});
        for (Recipe recipe : RecipeFinder.get((Object)turningRecipesKey, (Level)this.f_58857_, (Predicate)types)) {
            if (!(recipe instanceof TurningRecipe)) continue;
            TurningRecipe turningRecipe = (TurningRecipe)recipe;
            startedSearch.add(turningRecipe);
        }
        startedSearch = startedSearch.stream().filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inputInv.getStackInSlot(0))).filter(r -> !VintageRecipes.shouldIgnoreInAutomation(r)).sorted(Comparator.comparing(r -> r.m_8043_(this.m_58904_().m_9598_()).m_41778_())).collect(Collectors.toList());
        return startedSearch;
    }

    private Optional<TurningRecipe> getRecipe() {
        List<TurningRecipe> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return Optional.empty();
        }
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be == null) {
            return Optional.empty();
        }
        if (be.manualMode()) {
            return be.getTemporaryRecipe();
        }
        int index = be.getIndex(this.inputInv.getStackInSlot(0));
        if (index >= 0) {
            return Optional.of(recipes.get(index));
        }
        return Optional.empty();
    }

    private ItemStack getResultItem() {
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be == null) {
            return ItemStack.f_41583_;
        }
        if (!be.recipeSlot.getStackInSlot(0).m_41619_() && be.recipeSlot.getStackInSlot(0).m_41720_() instanceof RecipeCardItem) {
            return RecipeCardItem.getResultItems(be.recipeSlot.getStackInSlot(0)).getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("Timer", this.timer);
        compound.m_128350_("InitialTimer", this.initialTimer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.m_41619_()) {
            return;
        }
        compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
        this.playEvent = ItemStack.f_41583_;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128457_("Timer");
        this.initialTimer = compound.m_128457_("InitialTimer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.m_41619_()) {
            this.playEvent = ItemStack.f_41583_;
            AllSoundEvents.SANDING_SHORT.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
        }
    }

    public void tick() {
        Optional<TurningRecipe> recipe;
        super.tick();
        if (this.inputInv.m_7983_()) {
            this.lastRecipe = null;
            this.timer = 0.0f;
        }
        if (this.getSpeed() == 0.0f || this.getSlaveSpeed() == 0.0f) {
            return;
        }
        if (Math.abs(this.getSpeed()) < IRotate.SpeedLevel.FAST.getSpeedValue()) {
            return;
        }
        if (Math.abs(this.getSlaveSpeed()) < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0.0f && this.lastRecipe != null) {
            this.timer -= this.getProcessingSpeed();
            if (this.timer <= 0.0f) {
                if (this.f_58857_.f_46443_) {
                    this.lastRecipe = null;
                    return;
                }
                this.process();
            }
            return;
        }
        if (this.inputInv.m_7983_()) {
            return;
        }
        if (this.lastRecipe == null && (recipe = this.getRecipe()).isPresent() && ((Ingredient)recipe.get().m_7527_().get(0)).test(this.inputInv.getStackInSlot(0))) {
            this.lastRecipe = recipe.get();
            this.initialTimer = this.timer = (float)this.lastRecipe.getProcessingDuration();
            if (this.timer <= 0.0f) {
                this.timer = 200.0f;
                this.initialTimer = 200.0f;
            }
            this.sendData();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()), (IItemHandler)be.recipeSlot);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean checkItem(ItemStack stack) {
        if (!this.inputInv.m_7983_() || !this.outputInv.m_7983_()) {
            return false;
        }
        return this.canProcess(stack);
    }

    private boolean canProcess(ItemStack stack) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)stack, VintageRecipes.TURNING.getType(), TurningRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            return true;
        }
        return VintageRecipes.TURNING.find(inventoryIn, this.f_58857_).isPresent();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional<TurningRecipe> recipe = this.getRecipe();
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = recipe.get();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.m_41774_(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.lastRecipe = null;
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_LATHE);
        this.sendData();
        this.m_6596_();
    }

    public float getProcessingSpeed() {
        return 1.0f + Mth.m_14036_((float)((float)((int)((Math.abs(this.getSpeed()) - IRotate.SpeedLevel.FAST.getSpeedValue()) / (256.0f - IRotate.SpeedLevel.FAST.getSpeedValue()))) / 2.0f), (float)0.0f, (float)0.5f) + Mth.m_14036_((float)((float)((int)((Math.abs(this.getSlaveSpeed()) - IRotate.SpeedLevel.MEDIUM.getSpeedValue()) / (256.0f - IRotate.SpeedLevel.MEDIUM.getSpeedValue()))) / 2.0f), (float)0.0f, (float)0.5f);
    }

    public float getSlaveSpeed() {
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            return be.getSpeed();
        }
        return 0.0f;
    }

    public boolean isSlaveSpeedRequirementFulfilled() {
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            return be.isSpeedRequirementFulfilled();
        }
        return true;
    }

    public float calculateSlaveStressApplied() {
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            return be.calculateStressApplied();
        }
        return 0.0f;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean isSuperAdded = super.addToTooltip(tooltip, isPlayerSneaking);
        boolean bl = notFastEnough = !this.isSlaveSpeedRequirementFulfilled() && this.getSlaveSpeed() != 0.0f;
        if (this.overStressed && ((Boolean)AllConfigs.client().enableOverstressedTooltip.get()).booleanValue()) {
            CreateLang.translate((String)"gui.stressometer.overstressed", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = CreateLang.translateDirect((String)"gui.contraptions.network_overstressed", (Object[])new Object[0]);
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                CreateLang.builder().add(((Component)cutString.get(i)).m_6881_()).forGoggles(tooltip);
            }
            return true;
        }
        if (notFastEnough) {
            CreateLang.translate((String)"tooltip.speedRequirement", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = CreateLang.translateDirect((String)"gui.contraptions.not_fast_enough", (Object[])new Object[]{I18n.m_118938_((String)this.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0])});
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                CreateLang.builder().add(((Component)cutString.get(i)).m_6881_()).forGoggles(tooltip);
            }
            return true;
        }
        return isSuperAdded;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressAtBase = this.calculateSlaveStressApplied();
        CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, stressAtBase);
        LatheMovingBlockEntity be = (LatheMovingBlockEntity)this.f_58857_.m_7702_(LatheRotatingBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            if (be.manualMode()) {
                VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.manual_mode", new Object[0])).style(ChatFormatting.WHITE).forGoggles(tooltip);
                if (this.lastRecipe == null) {
                    VintageLang.translate("gui.goggles.current_recipe", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.no_recipe", new Object[0])).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
                } else {
                    VintageLang.translate("gui.goggles.current_recipe", new Object[0]).add(VintageLang.text((String)" ")).add(Component.m_237115_((String)this.lastRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41778_())).style(ChatFormatting.GREEN).forGoggles(tooltip);
                }
            } else {
                VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.automatic_mode", new Object[0])).style(ChatFormatting.GOLD).forGoggles(tooltip);
                if (this.lastRecipe == null) {
                    if (!this.getResultItem().m_150930_(Items.f_41852_)) {
                        VintageLang.translate("gui.goggles.current_recipe", new Object[0]).add(VintageLang.text((String)" ")).add(Component.m_237115_((String)this.getResultItem().m_41778_())).style(ChatFormatting.GREEN).forGoggles(tooltip);
                    } else {
                        VintageLang.translate("gui.goggles.current_recipe", new Object[0]).add(VintageLang.text((String)" ")).add(VintageLang.translate("gui.goggles.no_recipe", new Object[0])).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
                    }
                } else {
                    VintageLang.translate("gui.goggles.current_recipe", new Object[0]).add(VintageLang.text((String)" ")).add(Component.m_237115_((String)this.lastRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41778_())).style(ChatFormatting.GREEN).forGoggles(tooltip);
                }
            }
        }
        return true;
    }

    private class LatheInventoryHandler
    extends CombinedInvWrapper {
        public LatheInventoryHandler() {
            super(new IItemHandlerModifiable[]{LatheRotatingBlockEntity.this.inputInv, LatheRotatingBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (!LatheRotatingBlockEntity.this.inputInv.m_7983_() || !LatheRotatingBlockEntity.this.outputInv.m_7983_()) {
                return false;
            }
            if (LatheRotatingBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return LatheRotatingBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (LatheRotatingBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (LatheRotatingBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

