/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.grinder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.negodya1.vintageimprovements.VintagePartialModels;
import com.negodya1.vintageimprovements.content.kinetics.grinder.GrinderBlock;
import com.negodya1.vintageimprovements.content.kinetics.grinder.GrinderBlockEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class GrinderRenderer
extends SafeBlockEntityRenderer<GrinderBlockEntity> {
    public GrinderRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(GrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderBelt(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBelt(GrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        PartialModel partial;
        BlockState blockState = be.m_58900_();
        float speed = be.getSpeed();
        if (speed > 0.0f) {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_ACTIVE_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_ACTIVE_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_ACTIVE_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_ACTIVE_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_ACTIVE;
            };
        } else if (speed < 0.0f) {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_REVERSED_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_REVERSED_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_REVERSED_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_REVERSED_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_REVERSED;
            };
        } else {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_INACTIVE_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_INACTIVE_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_INACTIVE_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_INACTIVE_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_INACTIVE;
            };
        }
        SuperByteBuffer superBuffer = (SuperByteBuffer)CachedBuffers.partialFacing((PartialModel)partial, (BlockState)blockState, (Direction)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_))).rotateCentered(blockState.m_61143_((Property)BlockStateProperties.f_61374_) == Direction.WEST || blockState.m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH ? 0.0f : (float)Math.PI, Direction.UP);
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    protected void renderShaft(GrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
    }

    protected void renderItems(GrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.inventory.isEmpty()) {
            boolean alongZ = be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH || be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH;
            ms.m_85836_();
            boolean moving = be.inventory.recipeDuration != 0.0f;
            float offset = moving ? be.inventory.remainingTime / be.inventory.recipeDuration : 0.0f;
            float processingSpeed = Mth.m_14036_((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = Mth.m_14036_((float)(offset + (-partialTicks + 0.5f) * processingSpeed / be.inventory.recipeDuration), (float)0.125f, (float)1.0f);
                if (!be.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (be.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (be.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack stack = be.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                boolean blockItem = modelWithOverrides.m_7539_();
                ms.m_85837_(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                }
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
                break;
            }
            ms.m_85849_();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockState state = context.state;
        Direction facing = (Direction)state.m_61143_(GrinderBlock.HORIZONTAL_FACING);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_(GrinderBlock.HORIZONTAL_FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        boolean horizontal = closestToFacing.m_122434_().m_122479_();
        boolean backwards = VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.m_122424_());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = shouldAnimate ? CachedBuffers.partial((PartialModel)VintagePartialModels.GRINDER_BELT_ACTIVE, (BlockState)state) : CachedBuffers.partial((PartialModel)VintagePartialModels.GRINDER_BELT_INACTIVE, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateY(AngleHelper.horizontalAngle((Direction)facing))).rotateX(AngleHelper.verticalAngle((Direction)facing));
        if (!GrinderBlock.isHorizontal(state)) {
            superBuffer.rotateZ(0.0f);
        }
        ((SuperByteBuffer)superBuffer.uncenter()).light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110457_()));
    }
}

