/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.curving_press;

import com.google.gson.JsonObject;
import com.negodya1.vintageimprovements.VintageBlocks;
import com.negodya1.vintageimprovements.VintageItems;
import com.negodya1.vintageimprovements.VintageLang;
import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.compat.jei.category.assemblies.AssemblyCurving;
import com.negodya1.vintageimprovements.content.equipment.CurvingHeadItem;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class CurvingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    int mode = 1;
    int headDamage = 0;
    Item itemAsHead = Items.f_41852_;

    public CurvingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.CURVING, params);
    }

    public int getMode() {
        return this.mode;
    }

    public int getHeadDamage() {
        return this.headDamage;
    }

    public Item getItemAsHead() {
        return this.itemAsHead;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.curving", new Object[0]);
        result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.with_head", new Object[0])).m_130946_(" ");
        switch (this.mode) {
            case 2: {
                result.m_7220_((Component)Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.CONCAVE_CURVING_HEAD.get())).m_5524_()));
                break;
            }
            case 3: {
                result.m_7220_((Component)Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.W_SHAPED_CURVING_HEAD.get())).m_5524_()));
                break;
            }
            case 4: {
                result.m_7220_((Component)Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.V_SHAPED_CURVING_HEAD.get())).m_5524_()));
                break;
            }
            case 5: {
                result.m_7220_((Component)Component.m_237115_((String)this.itemAsHead.m_5524_()));
                break;
            }
            default: {
                result.m_7220_((Component)Component.m_237115_((String)((CurvingHeadItem)((Object)VintageItems.CONVEX_CURVING_HEAD.get())).m_5524_()));
            }
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.CURVING_PRESS.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyCurving::new;
    }

    public void readAdditional(JsonObject json) {
        this.headDamage = json.has("headDamage") ? json.get("headDamage").getAsInt() : 0;
        if (json.has("itemAsHead")) {
            this.itemAsHead = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("itemAsHead").getAsString()));
            if (this.itemAsHead != null) {
                this.mode = 5;
                return;
            }
        }
        this.mode = json.has("mode") ? json.get("mode").getAsInt() : 1;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.mode = buffer.readInt();
        this.itemAsHead = buffer.m_130267_().m_41720_();
        if (this.itemAsHead != Items.f_41852_) {
            this.mode = 5;
        }
        this.headDamage = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("mode", (Number)this.mode);
        if (this.itemAsHead != Items.f_41852_) {
            json.addProperty("itemAsHead", this.itemAsHead.toString());
        }
        if (this.headDamage >= 0) {
            json.addProperty("headDamage", (Number)this.mode);
        }
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.mode);
        buffer.m_130055_(new ItemStack((ItemLike)this.itemAsHead));
        buffer.writeInt(this.headDamage);
    }
}

