/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.centrifuge;

import com.negodya1.vintageimprovements.VintageBlockEntity;
import com.negodya1.vintageimprovements.VintageBlocks;
import com.negodya1.vintageimprovements.VintageShapes;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlock;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlockEntity;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeStructuralBlockEntity;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CentrifugeStructuralBlock
extends DirectionalBlock
implements IBE<CentrifugeStructuralBlockEntity>,
IWrenchable,
IProxyHoveringInformation {
    public static final VoxelShaper CENTRIFUGE_SHAPE = VintageShapes.shape(0.0, 2.0, 0.0, 16.0, 14.0, 16.0).forDirectional();

    public CentrifugeStructuralBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
    }

    public Class<CentrifugeStructuralBlockEntity> getBlockEntityClass() {
        return CentrifugeStructuralBlockEntity.class;
    }

    public BlockEntityType<? extends CentrifugeStructuralBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.CENTRIFUGE_STRUCTURAL.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CENTRIFUGE_SHAPE.get(Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_52588_}));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return VintageBlocks.CENTRIFUGE.asStack();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (this.stillValid((BlockGetter)level, clickedPos, state, false)) {
            BlockPos masterPos = CentrifugeStructuralBlock.getMaster((BlockGetter)level, clickedPos, state);
            context = new UseOnContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), masterPos, context.m_43721_()));
            state = level.m_8055_(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = pLevel.m_7702_(CentrifugeStructuralBlock.getMaster((BlockGetter)pLevel, pPos, pState));
        if (!(blockEntity instanceof CentrifugeBlockEntity)) {
            return InteractionResult.FAIL;
        }
        CentrifugeBlockEntity wwt = (CentrifugeBlockEntity)blockEntity;
        if (wwt.addBasin(pPlayer.m_21120_(pHand))) {
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21120_(pHand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (wwt.getBasins() >= 4 && wwt.addRedstoneApp(pPlayer.m_21120_(pHand))) {
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21120_(pHand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (wwt.getBasins() < 4 || wwt.getSpeed() != 0.0f) {
            return InteractionResult.PASS;
        }
        if (FluidHelper.tryEmptyItemIntoBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)pPlayer.m_21120_(pHand), (SmartBlockEntity)wwt)) {
            return InteractionResult.SUCCESS;
        }
        if (FluidHelper.tryFillItemFromBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)pPlayer.m_21120_(pHand), (SmartBlockEntity)wwt)) {
            return InteractionResult.SUCCESS;
        }
        if (GenericItemEmptying.canItemBeEmptied((Level)pLevel, (ItemStack)pPlayer.m_21120_(pHand)) || GenericItemFilling.canItemBeFilled((Level)pLevel, (ItemStack)pPlayer.m_21120_(pHand))) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_().equals(Items.f_41902_) && wwt.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> iFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty()) {
            return InteractionResult.SUCCESS;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)wwt.capability.orElse((Object)new ItemStackHandler(1));
        boolean success = false;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (stackInSlot.m_41619_()) continue;
            pPlayer.m_150109_().m_150079_(stackInSlot);
            inv.setStackInSlot(slot, ItemStack.f_41583_);
            success = true;
        }
        if (success) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        pLevel.m_46747_(pPos);
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            pLevel.m_46961_(CentrifugeStructuralBlock.getMaster((BlockGetter)pLevel, pPos, pState), true);
        }
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            BlockPos masterPos = CentrifugeStructuralBlock.getMaster((BlockGetter)pLevel, pPos, pState);
            pLevel.m_6801_(masterPos.hashCode(), masterPos, -1);
            if (!pLevel.m_5776_() && pPlayer.m_7500_()) {
                pLevel.m_46961_(masterPos, false);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        Level level;
        if (this.stillValid((BlockGetter)pLevel, pCurrentPos, pState, false)) {
            BlockPos masterPos = CentrifugeStructuralBlock.getMaster((BlockGetter)pLevel, pCurrentPos, pState);
            if (!pLevel.m_183326_().m_183582_(masterPos, (Object)((Block)VintageBlocks.CENTRIFUGE.get()))) {
                pLevel.m_186460_(masterPos, (Block)VintageBlocks.CENTRIFUGE.get(), 1);
            }
            return pState;
        }
        if (!(pLevel instanceof Level) || (level = (Level)pLevel).m_5776_()) {
            return pState;
        }
        if (!level.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            level.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public static BlockPos getMaster(BlockGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        if (targetedState.m_60713_((Block)VintageBlocks.CENTRIFUGE_STRUCTURAL.get())) {
            return CentrifugeStructuralBlock.getMaster(level, targetedPos, targetedState);
        }
        return targetedPos;
    }

    public boolean stillValid(BlockGetter level, BlockPos pos, BlockState state, boolean directlyAdjacent) {
        if (!state.m_60713_((Block)this)) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        if (!directlyAdjacent && this.stillValid(level, targetedPos, targetedState, true)) {
            return true;
        }
        return targetedState.m_60734_() instanceof CentrifugeBlock;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            this.getBlockEntity((BlockGetter)pLevel, pPos);
            pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new RenderProperties());
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return this.stillValid((BlockGetter)level, pos, state, false) ? CentrifugeStructuralBlock.getMaster((BlockGetter)level, pos, state) : pos;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        CentrifugeBlockEntity centrifuge = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.m_20183_())) {
            if (!worldIn.m_8055_(pos).m_60713_((Block)VintageBlocks.CENTRIFUGE_STRUCTURAL.get()) || centrifuge != null) continue;
            centrifuge = (CentrifugeBlockEntity)worldIn.m_7702_(CentrifugeStructuralBlock.getMaster(worldIn, pos, worldIn.m_8055_(pos)));
        }
        if (centrifuge == null) {
            return;
        }
        if (centrifuge.getBasins() < 4 || centrifuge.getSpeed() != 0.0f) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        LazyOptional capability = centrifuge.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!capability.isPresent()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(i, itemEntity.m_32055_(), false);
            if (remainder.m_41619_()) {
                itemEntity.m_146870_();
            }
            if (remainder.m_41613_() < itemEntity.m_32055_().m_41613_()) {
                itemEntity.m_32045_(remainder);
            }
            if (remainder.m_41619_()) break;
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(CentrifugeStructuralBlockEntity::getAnalogSignal).orElse(0);
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.m_82425_();
                CentrifugeStructuralBlock centrifugeStructuralBlock = (CentrifugeStructuralBlock)((Object)VintageBlocks.CENTRIFUGE_STRUCTURAL.get());
                if (centrifugeStructuralBlock.stillValid((BlockGetter)level, targetPos, state, false)) {
                    manager.m_107367_(CentrifugeStructuralBlock.getMaster((BlockGetter)level, targetPos, state), bhr.m_82434_());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            CentrifugeStructuralBlock centrifugeStructuralBlock = (CentrifugeStructuralBlock)((Object)VintageBlocks.CENTRIFUGE_STRUCTURAL.get());
            if (!centrifugeStructuralBlock.stillValid((BlockGetter)level, pos, blockState, false)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(CentrifugeStructuralBlock.getMaster((BlockGetter)level, pos, blockState));
            return set;
        }
    }
}

