/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.centrifuge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.negodya1.vintageimprovements.VintagePartialModels;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlock;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CentrifugeRenderer
extends KineticBlockEntityRenderer<CentrifugeBlockEntity> {
    List<Vec3> translates = new ArrayList<Vec3>();

    public CentrifugeRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.translates.add(new Vec3(1.75, 0.0, 0.0));
        this.translates.add(new Vec3(-1.75, 0.0, 0.0));
        this.translates.add(new Vec3(0.0, 0.0, 1.75));
        this.translates.add(new Vec3(0.0, 0.0, -1.75));
    }

    public boolean shouldRenderOffScreen(CentrifugeBlockEntity be) {
        return true;
    }

    protected void renderSafe(CentrifugeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)VintagePartialModels.CENTRIFUGE_BEAMS, (BlockState)blockState);
        CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
        if (be.getRedstoneApp()) {
            SuperByteBuffer redstoneBuffer = CachedBuffers.partial((PartialModel)VintagePartialModels.REDSTONE_MODULE_CENTRIFUGE, (BlockState)blockState);
            CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)redstoneBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
        }
        if (be.getBasins() > 0) {
            superBuffer = CachedBuffers.partial((PartialModel)VintagePartialModels.BASIN, (BlockState)blockState);
            ((SuperByteBuffer)CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).translate(1.75f, 0.0f, 0.0f)).renderInto(ms, vb);
            if (be.getBasins() > 1) {
                ((SuperByteBuffer)CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).translate(-1.75f, 0.0f, 0.0f)).renderInto(ms, vb);
                if (be.getBasins() > 2) {
                    ((SuperByteBuffer)CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).translate(0.0f, 0.0f, 1.75f)).renderInto(ms, vb);
                    if (be.getBasins() > 3) {
                        ((SuperByteBuffer)CentrifugeRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).translate(0.0f, 0.0f, -1.75f)).renderInto(ms, vb);
                        for (Vec3 translate : this.translates) {
                            ms.m_85836_();
                            BlockPos pos = be.m_58899_();
                            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateCentered(CentrifugeRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)Direction.Axis.Y), Direction.UP)).translate(translate);
                            float fluidLevel = this.renderFluids(be, partialTicks, ms, buffer, light, overlay);
                            float level = Mth.m_14036_((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
                            ms.m_85837_(0.5, (double)0.2f, 0.5);
                            TransformStack.of((PoseStack)ms).rotateY(be.ingredientRotation.getValue(partialTicks));
                            RandomSource r = RandomSource.m_216335_((long)pos.hashCode());
                            Vec3 baseVector = new Vec3(0.125, (double)level, 0.0);
                            IItemHandlerModifiable inv = (IItemHandlerModifiable)be.capability.orElse((Object)new ItemStackHandler());
                            int itemCount = 0;
                            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                                if (inv.getStackInSlot(slot).m_41619_()) continue;
                                ++itemCount;
                            }
                            if (itemCount == 1) {
                                baseVector = new Vec3(0.0, (double)level, 0.0);
                            }
                            float anglePartition = 360.0f / (float)itemCount;
                            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                                ItemStack stack = inv.getStackInSlot(slot);
                                if (stack.m_41619_()) continue;
                                ms.m_85836_();
                                if (fluidLevel > 0.0f) {
                                    ms.m_252880_(0.0f, (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f, 0.0f);
                                }
                                Vec3 itemPosition = VecHelper.rotate((Vec3)baseVector, (double)(anglePartition * (float)itemCount), (Direction.Axis)Direction.Axis.Y);
                                ms.m_85837_(itemPosition.f_82479_, itemPosition.f_82480_, itemPosition.f_82481_);
                                ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateY(anglePartition * (float)itemCount + 35.0f)).rotateX(65.0f);
                                for (int i = 0; i <= stack.m_41613_() / 8; ++i) {
                                    ms.m_85836_();
                                    Vec3 vec = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.0625f);
                                    ms.m_85837_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                                    this.renderItem(be, pos, ms, buffer, light, overlay, stack);
                                    ms.m_85849_();
                                }
                                ms.m_85849_();
                                --itemCount;
                            }
                            ms.m_85849_();
                            if (!(blockState.m_60734_() instanceof CentrifugeBlock)) {
                                return;
                            }
                            Direction direction = Direction.UP;
                            Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
                            Vec3 outVec = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_).m_82549_(directionVec.m_82490_(0.55).m_82492_(0.0, 0.5, 0.0));
                            boolean outToBasin = be.m_58904_().m_8055_(be.m_58899_().m_121945_(direction)).m_60734_() instanceof CentrifugeBlock;
                            for (IntAttached<ItemStack> intAttached : be.visualizedOutputItems) {
                                float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
                                if (!outToBasin && progress > 0.35f) continue;
                                ms.m_85836_();
                                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(outVec)).translate(new Vec3(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0))).translate(directionVec.m_82490_((double)(progress * 0.5f)))).rotateY(AngleHelper.horizontalAngle((Direction)direction))).rotateX(progress * 180.0f);
                                this.renderItem(be, pos, ms, buffer, light, overlay, (ItemStack)intAttached.getValue());
                                ms.m_85849_();
                            }
                        }
                    }
                }
            }
        }
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderItem(CentrifugeBlockEntity be, BlockPos pos, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
    }

    protected float renderFluids(CentrifugeBlockEntity basin, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputFluids = (SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = (SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = new SmartFluidTankBehaviour[]{inputFluids, outputFluids};
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float fluidLevel = Mth.m_14036_((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        float xMin = 0.125f;
        float xMax = 0.125f;
        float yMin = 0.125f;
        float yMax = 0.125f + 0.75f * fluidLevel;
        float zMin = 0.125f;
        float zMax = 0.875f;
        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = Mth.m_14036_((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)renderedFluid, xMin, 0.125f, 0.125f, xMax += partial * 12.0f / 16.0f, yMax, 0.875f, buffer, ms, light, false, false);
                xMin = xMax;
            }
        }
        return yMax;
    }

    protected void renderShaft(CentrifugeBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be, be.m_58900_()), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
    }

    protected SuperByteBuffer getRotatedModel(CentrifugeBlockEntity be, BlockState state) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(CentrifugeBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

