/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.centrifuge;

import com.negodya1.vintageimprovements.VintageItems;
import com.negodya1.vintageimprovements.VintageLang;
import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugationRecipe;
import com.negodya1.vintageimprovements.content.kinetics.centrifuge.CentrifugeBlock;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancementBehaviour;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancements;
import com.negodya1.vintageimprovements.infrastructure.config.VintageConfig;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CentrifugeBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inputInv;
    public SmartInventory outputInv;
    public SmartFluidTankBehaviour inputTank;
    public SmartFluidTankBehaviour outputTank;
    private Couple<SmartFluidTankBehaviour> tanks;
    public LazyOptional<IItemHandlerModifiable> capability;
    public LazyOptional<IFluidHandler> fluidCapability;
    public int timer;
    private CentrifugationRecipe lastRecipe;
    private int basins = 0;
    private boolean redstoneApp = false;
    boolean lastRecipeIsAssembly;
    private boolean contentsChanged;
    private static final Object centrifugationRecipesKey = new Object();
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<IntAttached<ItemStack>> visualizedOutputItems;
    LerpedFloat ingredientRotationSpeed;
    LerpedFloat ingredientRotation;
    VintageAdvancementBehaviour advancementBehaviour;
    private final CompoundTag nbtForAnim = new CompoundTag();

    public CentrifugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInv = new SmartInventory(9, (SyncedBlockEntity)this);
        this.outputInv = new SmartInventory(9, (SyncedBlockEntity)this);
        this.capability = LazyOptional.of(() -> new CentrifugeInventoryHandler(new IItemHandlerModifiable[]{this.inputInv, this.outputInv}));
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.tanks = Couple.create((Object)this.inputTank, (Object)this.outputTank);
    }

    public int getBasins() {
        return this.basins;
    }

    public boolean addBasin(ItemStack items) {
        if (this.basins >= 4) {
            return false;
        }
        if (items.m_41720_() != AllBlocks.BASIN.m_5456_()) {
            return false;
        }
        ++this.basins;
        return true;
    }

    public boolean getRedstoneApp() {
        return this.redstoneApp;
    }

    public boolean addRedstoneApp(ItemStack items) {
        if (this.redstoneApp) {
            return false;
        }
        if (items.m_41720_() != VintageItems.REDSTONE_MODULE.get()) {
            return false;
        }
        this.redstoneApp = true;
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CentrifugeTanksHandler((IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null));
        });
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        compound.m_128379_("LastRecipeIsAssembly", this.lastRecipeIsAssembly);
        compound.m_128405_("Basins", this.basins);
        compound.m_128379_("RedstoneApp", this.redstoneApp);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)this.nbtForAnim.m_128437_("VisualizedItems", 10), c -> this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.with((int)10, (Object)ItemStack.m_41712_((CompoundTag)c))));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        this.lastRecipeIsAssembly = compound.m_128471_("LastRecipeIsAssembly");
        this.basins = compound.m_128451_("Basins");
        this.redstoneApp = compound.m_128471_("RedstoneApp");
        if (!clientPacket) {
            return;
        }
        this.nbtForAnim.m_128365_("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        this.visualizedOutputItems.clear();
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(2.0);
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    protected <C extends Container> boolean matchCentrifugeRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return CentrifugationRecipe.match(this, recipe);
    }

    private List<Recipe<?>> getRecipes() {
        List list = RecipeFinder.get((Object)centrifugationRecipesKey, (Level)this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchCentrifugeRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r.m_6671_() == VintageRecipes.CENTRIFUGATION.getType();
    }

    public boolean isProccesingNow() {
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inputInv.getStackInSlot(i), VintageRecipes.CENTRIFUGATION.getType(), CentrifugationRecipe.class);
            if (!assemblyRecipe.isPresent()) continue;
            return CentrifugationRecipe.match(this, (Recipe)assemblyRecipe.get());
        }
        List<Recipe<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return false;
        }
        if (this.inputInv.m_7983_() && this.inputTank.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41619_() || this.outputInv.getStackInSlot(i).m_41613_() < this.outputInv.getStackInSlot(i).m_41741_()) continue;
            return false;
        }
        Recipe<?> recipe = recipes.get(0);
        if (recipe instanceof CentrifugationRecipe) {
            CentrifugationRecipe centrifugationRecipe = (CentrifugationRecipe)recipe;
            boolean res = this.acceptOutputs(centrifugationRecipe.getRollableResultsAsItemStacks(), (List<FluidStack>)centrifugationRecipe.getFluidResults(), true);
            if (!res) {
                return false;
            }
            return CentrifugationRecipe.match(this, centrifugationRecipe);
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue((double)(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue()));
        }
        if (this.getBasins() < 4) {
            return;
        }
        if (this.timer > 0) {
            if (this.getSpeed() == 0.0f) {
                this.timer = 0;
                this.lastRecipe = null;
            }
            if (this.lastRecipe != null && Mth.m_14154_((float)this.getSpeed()) < (float)this.lastRecipe.minimalRPM) {
                this.timer = this.lastRecipe.getProcessingDuration();
            }
            if (this.lastRecipe != null && Mth.m_14154_((float)this.getSpeed()) >= (float)this.lastRecipe.minimalRPM) {
                this.timer -= this.getProcessingSpeed();
                if (this.f_58857_.f_46443_) {
                    return;
                }
                if (this.timer <= 0) {
                    this.process();
                }
                return;
            }
        }
        if (this.inputInv.m_7983_() && this.inputTank.isEmpty()) {
            return;
        }
        if (this.lastRecipe == null || !CentrifugationRecipe.match(this, this.lastRecipe)) {
            for (int i = 0; i < this.inputInv.getSlots(); ++i) {
                Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inputInv.getStackInSlot(i), VintageRecipes.CENTRIFUGATION.getType(), CentrifugationRecipe.class);
                if (!assemblyRecipe.isPresent()) continue;
                boolean found = true;
                for (Ingredient cur : ((CentrifugationRecipe)((Object)assemblyRecipe.get())).m_7527_()) {
                    boolean find = false;
                    for (ItemStack item : cur.m_43908_()) {
                        if (item.m_41613_() > this.inputInv.m_18947_(item.m_41720_())) continue;
                        find = true;
                        break;
                    }
                    found = find;
                }
                if (!found) continue;
                this.lastRecipe = (CentrifugationRecipe)((Object)assemblyRecipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
                if (this.timer == 0) {
                    this.timer = 100;
                }
                this.lastRecipeIsAssembly = true;
                this.sendData();
                return;
            }
            this.lastRecipeIsAssembly = false;
            List<Recipe<?>> recipes = this.getRecipes();
            if (!recipes.isEmpty()) {
                this.lastRecipe = (CentrifugationRecipe)recipes.get(0);
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
                return;
            }
            this.timer = 100;
            this.sendData();
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        if (this.timer == 0) {
            this.timer = 100;
        }
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
        this.fluidCapability.invalidate();
    }

    public void destroy() {
        super.destroy();
        if (this.getBasins() > 0) {
            SmartInventory basinsInv = new SmartInventory(9, (SyncedBlockEntity)this);
            ItemHandlerHelper.insertItemStacked((IItemHandler)basinsInv, (ItemStack)AllBlocks.BASIN.asStack(this.getBasins()), (boolean)false);
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)basinsInv);
        }
        if (this.redstoneApp) {
            SmartInventory redstoneInv = new SmartInventory(9, (SyncedBlockEntity)this);
            ItemHandlerHelper.insertItemStacked((IItemHandler)redstoneInv, (ItemStack)new ItemStack((ItemLike)((Item)VintageItems.REDSTONE_MODULE.get()).m_5456_()), (boolean)false);
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)redstoneInv);
        }
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canProcess() {
        return (this.getSpeed() == 0.0f || (Boolean)VintageConfig.common().easyCentrifuge.get() != false) && this.getBasins() >= 4;
    }

    public SmartInventory getInputInventory() {
        return this.inputInv;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInv;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInv.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInv.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof CentrifugeBlock)) {
            return false;
        }
        SmartInventory targetInv = this.outputInv;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoCentrifuge(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoCentrifuge(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoCentrifuge(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoCentrifuge(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void process() {
        if (this.lastRecipe == null || !CentrifugationRecipe.match(this, this.lastRecipe)) {
            List<Recipe<?>> recipes;
            boolean found = false;
            for (int i = 0; i < this.inputInv.getSlots(); ++i) {
                Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inputInv.getStackInSlot(i), VintageRecipes.CENTRIFUGATION.getType(), CentrifugationRecipe.class);
                if (!assemblyRecipe.isPresent()) continue;
                this.lastRecipe = (CentrifugationRecipe)((Object)assemblyRecipe.get());
                this.lastRecipeIsAssembly = true;
                found = true;
                break;
            }
            if (!found && !(recipes = this.getRecipes()).isEmpty()) {
                this.lastRecipe = (CentrifugationRecipe)recipes.get(0);
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (CentrifugationRecipe.apply(this, this.lastRecipe) && this.lastRecipeIsAssembly) {
            this.lastRecipe = null;
        }
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_CENTRIFUGE);
        this.sendData();
        this.m_6596_();
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.basins >= 4) {
            if (this.redstoneApp) {
                VintageLang.translate("gui.goggles.redstone_module", new Object[0]).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
            }
            if (this.lastRecipe != null && (float)this.lastRecipe.minimalRPM > Mth.m_14154_((float)this.getSpeed())) {
                VintageLang.translate("gui.goggles.not_enough_rpm", new Object[0]).add(CreateLang.text((String)" ")).add(CreateLang.number((double)this.lastRecipe.minimalRPM)).style(ChatFormatting.RED).forGoggles(tooltip);
            }
            IItemHandlerModifiable items = (IItemHandlerModifiable)this.capability.orElse((Object)new ItemStackHandler());
            IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
            boolean isEmpty = true;
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stackInSlot = items.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                CreateLang.text((String)"").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
                isEmpty = false;
            }
            LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
            for (int i = 0; i < fluids.getTanks(); ++i) {
                FluidStack fluidStack = fluids.getFluidInTank(i);
                if (fluidStack.isEmpty()) continue;
                CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
                isEmpty = false;
            }
            if (isEmpty) {
                tooltip.remove(0);
            }
            return true;
        }
        VintageLang.translate("gui.goggles.not_enough_basins", new Object[0]).add(CreateLang.text((String)" ")).add(CreateLang.number((double)(4 - this.basins))).style(ChatFormatting.GOLD).forGoggles(tooltip);
        return true;
    }

    private class CentrifugeTanksHandler
    extends CombinedTankWrapper {
        public CentrifugeTanksHandler(IFluidHandler ... fluidHandlers) {
            super(fluidHandlers);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            if (CentrifugeBlockEntity.this.outputTank == this.getHandlerFromIndex(this.getIndexForSlot(tank))) {
                return false;
            }
            return CentrifugeBlockEntity.this.canProcess() && super.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (CentrifugeBlockEntity.this.canProcess()) {
                return super.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (CentrifugeBlockEntity.this.canProcess()) {
                return super.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (CentrifugeBlockEntity.this.canProcess()) {
                return super.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }

    private class CentrifugeInventoryHandler
    extends CombinedInvWrapper {
        public CentrifugeInventoryHandler(IItemHandlerModifiable ... itemHandlers) {
            super(itemHandlers);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (CentrifugeBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return CentrifugeBlockEntity.this.canProcess() && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (CentrifugeBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot)) || !this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CentrifugeBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot)) || !CentrifugeBlockEntity.this.canProcess()) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

