/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.compat.jei.category;

import com.negodya1.vintageimprovements.compat.jei.VintageRecipeUtil;
import com.negodya1.vintageimprovements.compat.jei.category.animations.AnimatedVacuumChamber;
import com.negodya1.vintageimprovements.content.kinetics.vacuum_chamber.VacuumizingRecipe;
import com.negodya1.vintageimprovements.foundation.gui.VintageGuiTextures;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class VacuumizingCategory
extends BasinCategory {
    private final AnimatedVacuumChamber vacuum = new AnimatedVacuumChamber();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public VacuumizingCategory(CreateRecipeCategory.Info<BasinRecipe> info) {
        super(info, true);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BasinRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Object pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).m_43908_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(VacuumizingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        int j = 0;
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            VacuumizingRecipe r;
            if (recipe instanceof VacuumizingRecipe && j == (r = (VacuumizingRecipe)recipe).getSecondaryFluidInputs()) {
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)21, (int)14, (FluidIngredient)fluidIngredient).addRichTooltipCallback(VintageRecipeUtil.addTooltip("jei.text.secondary_fluid_ingredient"));
            } else {
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)(17 + xOffset + i % 3 * 19), (int)(51 - i / 3 * 19), (FluidIngredient)fluidIngredient);
            }
            ++i;
            ++j;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(VacuumizingCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addRichTooltipCallback(VacuumizingCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        j = 0;
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            if (!(recipe instanceof VacuumizingRecipe)) continue;
            VacuumizingRecipe vRecipe = (VacuumizingRecipe)recipe;
            int secondary = vRecipe.getSecondaryFluidResults();
            if (j == secondary) {
                xPosition = 140;
                yPosition = 2;
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult).addRichTooltipCallback(VintageRecipeUtil.addTooltip("jei.text.secondary_fluid_result"));
            } else {
                xPosition = 142 - ((secondary >= 0 ? size - 1 : size) % 2 != 0 && i == (secondary >= 0 ? size - 1 : size) - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
                yPosition = -19 * (i / 2) + 51;
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult);
            }
            ++i;
            ++j;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 81).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat;
        super.draw(recipe, iRecipeSlotsView, graphics, mouseX, mouseY);
        if (recipe instanceof VacuumizingRecipe) {
            VacuumizingRecipe vrecipe = (VacuumizingRecipe)recipe;
            if (vrecipe.getSecondaryFluidResults() >= 0 && vrecipe.getFluidResults().size() > 0) {
                VintageGuiTextures.JEI_UP_TO_RIGHT_ARROW.render(graphics, 120, 2);
            }
            if (vrecipe.getSecondaryFluidInputs() >= 0 && vrecipe.getFluidIngredients().size() > 0) {
                AllGuiTextures.JEI_ARROW.render(graphics, 45, 18);
            }
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.vacuum.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34, false);
    }
}

