/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.ruletest;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public record AlternatePropertiesPredicate(List<PropertyMatcher> properties) {
    private static final Codec<List<PropertyMatcher>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ValueMatcher.CODEC).orElse(Map.of()).xmap(map -> map.entrySet().stream().map(PropertyMatcher::new).toList(), matchers -> matchers.stream().collect(Collectors.toMap(PropertyMatcher::name, PropertyMatcher::valueMatcher)));
    public static final Codec<AlternatePropertiesPredicate> CODEC = PROPERTIES_CODEC.xmap(AlternatePropertiesPredicate::new, AlternatePropertiesPredicate::properties);

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> $$0, S $$1) {
        for (PropertyMatcher matcher : this.properties) {
            if (matcher.match($$0, $$1)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState $$0) {
        return this.matches($$0.m_60734_().m_49965_(), $$0);
    }

    private record PropertyMatcher(String name, ValueMatcher valueMatcher) {
        public PropertyMatcher(Map.Entry<String, ValueMatcher> map) {
            this(map.getKey(), map.getValue());
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> stateDefinition, S $$1) {
            Property $$2 = stateDefinition.m_61081_(this.name);
            return $$2 != null && this.valueMatcher.match($$1, $$2);
        }
    }

    private static interface ValueMatcher {
        public static final Codec<ValueMatcher> CODEC = Codec.either(ExactMatcher.CODEC, RangedMatcher.CODEC).xmap(either -> (ValueMatcher)either.map(Function.identity(), Function.identity()), matcher -> {
            if (matcher instanceof ExactMatcher) {
                ExactMatcher exactMatcher = (ExactMatcher)matcher;
                return Either.left((Object)exactMatcher);
            }
            if (matcher instanceof RangedMatcher) {
                RangedMatcher rangedMatcher = (RangedMatcher)matcher;
                return Either.right((Object)rangedMatcher);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);
    }

    private record ExactMatcher(String value) implements ValueMatcher
    {
        public static final Codec<ExactMatcher> CODEC = Codec.STRING.xmap(ExactMatcher::new, ExactMatcher::value);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> stateHolder, Property<T> property) {
            Comparable $$2 = stateHolder.m_61143_(property);
            Optional $$3 = property.m_6215_(this.value);
            return $$3.isPresent() && $$2.compareTo((Comparable)$$3.get()) == 0;
        }
    }

    private record RangedMatcher(Optional<String> minValue, Optional<String> maxValue) implements ValueMatcher
    {
        public static final Codec<RangedMatcher> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("min").forGetter(RangedMatcher::minValue), (App)Codec.STRING.optionalFieldOf("max").forGetter(RangedMatcher::maxValue)).apply((Applicative)instance, RangedMatcher::new));

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> stateHolder, Property<T> property) {
            Optional $$4;
            Comparable $$2 = stateHolder.m_61143_(property);
            if (this.minValue.isPresent() && (($$4 = property.m_6215_(this.minValue.get())).isEmpty() || $$2.compareTo((Comparable)$$4.get()) < 0)) {
                return false;
            }
            if (this.maxValue.isPresent()) {
                $$4 = property.m_6215_(this.maxValue.get());
                return $$4.isPresent() && $$2.compareTo((Comparable)$$4.get()) <= 0;
            }
            return true;
        }
    }
}

