/*
 * Decompiled with CFR 0.152.
 */
package com.cosmicgelatin.seasonals.core;

import com.cosmicgelatin.seasonals.core.ModIntegration;
import com.cosmicgelatin.seasonals.core.SeasonalsConfig;
import com.cosmicgelatin.seasonals.core.data.client.SeasonalsBlockStateProvider;
import com.cosmicgelatin.seasonals.core.data.client.SeasonalsItemModelProvider;
import com.cosmicgelatin.seasonals.core.data.client.SeasonalsLangProvider;
import com.cosmicgelatin.seasonals.core.data.server.SeasonalsRecipeProvider;
import com.cosmicgelatin.seasonals.core.data.server.loot.SeasonalsLootTableProvider;
import com.cosmicgelatin.seasonals.core.data.server.modifier.SeasonalsAdvancementModifierProvider;
import com.cosmicgelatin.seasonals.core.data.server.modifier.SeasonalsLootModifierProvider;
import com.cosmicgelatin.seasonals.core.data.server.tags.SeasonalsBlockTagsProvider;
import com.cosmicgelatin.seasonals.core.data.server.tags.SeasonalsDamageTypeTagsProvider;
import com.cosmicgelatin.seasonals.core.data.server.tags.SeasonalsItemTagsProvider;
import com.cosmicgelatin.seasonals.core.other.SeasonalsCauldronInteractions;
import com.cosmicgelatin.seasonals.core.other.SeasonalsCompat;
import com.cosmicgelatin.seasonals.core.other.SeasonalsCreativeModTabContents;
import com.cosmicgelatin.seasonals.core.registry.SeasonalsLootConditions;
import com.cosmicgelatin.seasonals.core.registry.SeasonalsMobEffects;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="seasonals")
@Mod.EventBusSubscriber(modid="seasonals")
public class Seasonals {
    public static final String MODID = "seasonals";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("seasonals");

    public static ResourceLocation modPrefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    public Seasonals() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(modEventBus);
        SeasonalsMobEffects.EFFECTS.register(modEventBus);
        SeasonalsLootConditions.LOOT_ITEM_CONDITION_TYPE.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SeasonalsConfig.COMMON_SPEC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SeasonalsCreativeModTabContents::buildSeasonalsCreativeTabContents);
        if (ModIntegration.isFDLoaded()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SeasonalsCreativeModTabContents::buildFDCreativeTabContents);
        }
        modEventBus.addListener(this::setupCommon);
        modEventBus.addListener(this::gatherData);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SeasonalsCompat.registerCompostables();
            SeasonalsCauldronInteractions.registerCauldronInteractions();
        });
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new SeasonalsBlockStateProvider(output, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SeasonalsItemModelProvider(output, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SeasonalsLangProvider(output));
        generator.addProvider(includeServer, (DataProvider)new SeasonalsLootTableProvider(output));
        SeasonalsBlockTagsProvider blockTagsProvider = new SeasonalsBlockTagsProvider(output, lookupProvider, fileHelper);
        generator.addProvider(includeServer, (DataProvider)blockTagsProvider);
        generator.addProvider(includeServer, (DataProvider)new SeasonalsItemTagsProvider(output, lookupProvider, blockTagsProvider.m_274426_(), fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SeasonalsDamageTypeTagsProvider(output, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SeasonalsAdvancementModifierProvider(output, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SeasonalsLootModifierProvider(output, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SeasonalsRecipeProvider(output));
    }
}

