/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client;

import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.ConfigState;
import dev.worldgen.tectonic.config.state.NoiseState;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;

public interface ConfigListBuilder {
    public void addCategory(String var1, Font var2);

    public void addBoolean(String var1, Consumer<Boolean> var2, boolean var3, boolean var4);

    public void addInteger(String var1, double var2, double var4, Consumer<Integer> var6, double var7, double var9);

    public void addDouble(String var1, double var2, double var4, double var6, Consumer<Double> var8, double var9, double var11);

    public void addNoise(String var1, NoiseState var2, NoiseState var3);

    default public void build(Font font) {
        ConfigState state = ConfigHandler.getState();
        this.addCategory("general", font);
        this.addBoolean("mod_enabled", bool -> {
            state.general.modEnabled = bool;
        }, state.general.modEnabled, true);
        this.addInteger("snow_start_offset", 0.0, 256.0, value -> {
            state.general.snowStartOffset = value;
        }, state.general.snowStartOffset, 128.0);
        this.addCategory("global_terrain", font);
        this.addDouble("vertical_scale", 0.75, 4.0, 0.005, value -> {
            state.globalTerrain.verticalScale = value;
        }, state.globalTerrain.verticalScale, 1.125);
        this.addBoolean("increased_height", bool -> {
            state.globalTerrain.increasedHeight = bool;
        }, state.globalTerrain.increasedHeight, false);
        this.addBoolean("ultrasmooth", bool -> {
            state.globalTerrain.ultrasmooth = bool;
        }, state.globalTerrain.ultrasmooth, false);
        this.addCategory("continents", font);
        this.addDouble("ocean_offset", -2.0, 0.0, 0.01, value -> {
            state.continents.oceanOffset = value;
        }, state.continents.oceanOffset, -0.8);
        this.addDouble("continents_scale", 0.01, 1.0, 0.01, value -> {
            state.continents.continentsScale = value;
        }, state.continents.continentsScale, 0.13);
        this.addDouble("erosion_scale", 0.01, 1.0, 0.01, value -> {
            state.continents.erosionScale = value;
        }, state.continents.erosionScale, 0.25);
        this.addDouble("ridge_scale", 0.01, 2.0, 0.01, value -> {
            state.continents.ridgeScale = value;
        }, state.continents.ridgeScale, 0.25);
        this.addBoolean("underground_rivers", bool -> {
            state.continents.undergroundRivers = bool;
        }, state.continents.undergroundRivers, true);
        this.addBoolean("river_lanterns", bool -> {
            state.continents.riverLanterns = bool;
        }, state.continents.riverLanterns, true);
        this.addDouble("flat_terrain_skew", -1.0, 1.0, 0.01, value -> {
            state.continents.flatTerrainSkew = value;
        }, state.continents.flatTerrainSkew, 0.1);
        this.addBoolean("rolling_hills", bool -> {
            state.continents.rollingHills = bool;
        }, state.continents.rollingHills, true);
        this.addBoolean("jungle_pillars", bool -> {
            state.continents.junglePillars = bool;
        }, state.continents.junglePillars, true);
        this.addCategory("islands", font);
        this.addBoolean("enabled", bool -> {
            state.islands.enabled = bool;
        }, state.islands.enabled, true);
        this.addNoise("noise", state.islands.noise, ConfigState.Islands.NOISE);
        this.addCategory("oceans", font);
        this.addDouble("ocean_depth", -0.75, -0.05, 0.01, value -> {
            state.oceans.oceanDepth = value;
        }, state.oceans.oceanDepth, -0.22);
        this.addDouble("deep_ocean_depth", -0.75, -0.05, 0.01, value -> {
            state.oceans.deepOceanDepth = value;
        }, state.oceans.deepOceanDepth, -0.45);
        this.addInteger("monument_offset", -60.0, 0.0, value -> {
            state.oceans.monumentOffset = value;
        }, state.oceans.monumentOffset, -30.0);
        this.addBoolean("remove_frozen_ocean_ice", bool -> {
            state.oceans.removeFrozenOceanIce = bool;
        }, state.oceans.removeFrozenOceanIce, false);
        this.addCategory("biomes", font);
        this.addNoise("temperature", state.biomes.temperature, NoiseState.DEFAULT);
        this.addNoise("vegetation", state.biomes.vegetation, NoiseState.DEFAULT);
        this.addCategory("caves", font);
        this.addDouble("depth_cutoff_start", -0.1, 1.0, 0.1, value -> {
            state.caves.depthCutoffStart = value;
        }, state.caves.depthCutoffStart, 0.1);
        this.addDouble("depth_cutoff_size", 0.0, 1.0, 0.1, value -> {
            state.caves.depthCutoffSize = value;
        }, state.caves.depthCutoffSize, 0.1);
        this.addBoolean("cheese_enabled", bool -> {
            state.caves.cheeseEnabled = bool;
        }, state.caves.cheeseEnabled, true);
        this.addDouble("cheese_additive", -0.5, 0.5, 0.01, value -> {
            state.caves.cheeseAdditive = value;
        }, state.caves.cheeseAdditive, 0.27);
        this.addBoolean("noodle_enabled", bool -> {
            state.caves.noodleEnabled = bool;
        }, state.caves.noodleEnabled, true);
        this.addDouble("noodle_additive", -0.25, 0.25, 0.025, value -> {
            state.caves.noodleAdditive = value;
        }, state.caves.noodleAdditive, -0.075);
        this.addBoolean("spaghetti_enabled", bool -> {
            state.caves.spaghettiEnabled = bool;
        }, state.caves.spaghettiEnabled, true);
        this.addBoolean("carvers_enabled", bool -> {
            state.caves.carversEnabled = bool;
        }, state.caves.carversEnabled, true);
        this.addBoolean("lava_tunnels", bool -> {
            state.globalTerrain.lavaTunnels = bool;
        }, state.globalTerrain.lavaTunnels, true);
    }
}

