/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.events;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import dev.xkmc.youkaishomecoming.content.capability.GrazeCapability;
import dev.xkmc.youkaishomecoming.content.effect.UdumbaraEffect;
import dev.xkmc.youkaishomecoming.content.entity.animal.tuna.TunaEntity;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.TouhouHatItem;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class YHAttackListener
implements AttackListener {
    public void onAttack(AttackCache cache, ItemStack weapon) {
        LivingAttackEvent event = cache.getLivingAttackEvent();
        assert (event != null);
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268745_) && event.getEntity().m_21023_((MobEffect)YHEffects.REFRESHING.get())) {
            event.setCanceled(true);
        }
    }

    public void onHurt(AttackCache cache, ItemStack weapon) {
        Entity entity;
        LivingHurtEvent event = cache.getLivingHurtEvent();
        assert (event != null);
        DamageSource source = event.getSource();
        if (source.m_269533_(YHDamageTypes.DANMAKU_TYPE) && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            GrazeCapability graze = (GrazeCapability)GrazeCapability.HOLDER.get(player);
            cache.addHurtModifier(DamageModifier.multTotal((float)(1.0f + graze.powerBonus())));
        }
        if (source.m_7639_() instanceof TunaEntity && cache.getAttackTarget() instanceof WaterAnimal) {
            cache.addHurtModifier(DamageModifier.multTotal((float)2.0f));
        }
    }

    public void onDamage(AttackCache cache, ItemStack weapon) {
        Level level;
        MobEffectInstance udu;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268437_) || source.m_269533_(DamageTypeTags.f_268630_) || source.m_269533_(DamageTypeTags.f_268738_)) {
            return;
        }
        int reduction = 0;
        LivingEntity e = event.getEntity();
        if (e.m_21023_((MobEffect)YHEffects.THICK.get())) {
            ++reduction;
        }
        if ((udu = e.m_21124_((MobEffect)YHEffects.UDUMBARA.get())) != null && (level = e.m_9236_()).m_46462_() && (level.m_45527_(e.m_20183_().m_7494_()) && level.m_46940_() > 0.8f || UdumbaraEffect.hasLantern(e))) {
            reduction += (Integer)YHModConfig.COMMON.udumbaraFullMoonReduction.get() << udu.m_19564_();
        }
        if (reduction > 0) {
            cache.addDealtModifier(DamageModifier.add((float)(-reduction)));
        }
        MobEffectInstance mature = e.m_21124_((MobEffect)YHEffects.MATURE.get());
        MobEffectInstance nourishment = e.m_21124_((MobEffect)ModEffects.NOURISHMENT.get());
        if (mature != null && nourishment != null) {
            cache.addDealtModifier(DamageModifier.nonlinearMiddle((int)182, f -> {
                int max = Math.min((int)(f * 0.2f * (float)(mature.m_19564_() + 1)), nourishment.m_19557_() / 100);
                e.m_21195_((MobEffect)ModEffects.NOURISHMENT.get());
                new EffectBuilder(nourishment).setDuration(nourishment.m_19557_() - max * 100);
                e.m_7292_(nourishment);
                return f - (float)max;
            }));
        }
    }

    public void onDamageFinalized(AttackCache cache, ItemStack weapon) {
        LivingEntity target;
        MobEffectInstance ins;
        LivingEntity attacker = cache.getAttacker();
        if (attacker == null) {
            return;
        }
        LivingDamageEvent damageEvent = cache.getLivingDamageEvent();
        assert (damageEvent != null);
        ItemStack head = attacker.m_6844_(EquipmentSlot.HEAD);
        Item item = head.m_41720_();
        if (item instanceof TouhouHatItem) {
            TouhouHatItem hat = (TouhouHatItem)item;
            hat.onHurtTarget(head, damageEvent.getSource(), cache.getAttackTarget());
        }
        if ((ins = (target = cache.getAttackTarget()).m_21124_((MobEffect)YHEffects.CONFIDENT.get())) != null) {
            target.f_19802_ += (ins.m_19564_() + 1) * 6;
        }
    }
}

