/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.spellcard;

import dev.xkmc.fastprojectileapi.collision.EntityStorageHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterData;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface LivingCardHolder
extends CardHolder {
    @Override
    public LivingEntity self();

    public LivingEntity shooter();

    @Override
    default public Vec3 center() {
        return this.self().m_20182_().m_82520_(0.0, (double)(this.self().m_20206_() / 2.0f), 0.0);
    }

    @Override
    default public Vec3 forward() {
        Vec3 target = this.target();
        if (target != null) {
            return target.m_82546_(this.center()).m_82541_();
        }
        return this.self().m_20156_();
    }

    @Override
    @Nullable
    default public Vec3 target() {
        LivingEntity le = this.targetEntity();
        if (le == null) {
            return null;
        }
        return le.m_20182_().m_82520_(0.0, (double)(le.m_20206_() / 2.0f), 0.0);
    }

    @Override
    @Nullable
    default public Vec3 targetVelocity() {
        LivingEntity le = this.targetEntity();
        if (le == null) {
            return null;
        }
        return le.m_20184_();
    }

    @Override
    default public RandomSource random() {
        return this.self().m_217043_();
    }

    @Override
    default public ItemDanmakuEntity prepareDanmaku(int life, Vec3 vec, YHDanmaku.Bullet type, DyeColor color) {
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType<? extends ItemDanmakuEntity>)((EntityType)YHEntities.ITEM_DANMAKU.get()), this.shooter(), this.self().m_9236_());
        danmaku.m_146884_(this.center());
        danmaku.setItem(type.get(color).asStack());
        danmaku.setup(this.getDamage(type), life, true, true, vec);
        return danmaku;
    }

    @Override
    default public ItemLaserEntity prepareLaser(int life, Vec3 pos, Vec3 vec, float len, YHDanmaku.Laser type, DyeColor color) {
        ItemLaserEntity danmaku = new ItemLaserEntity((EntityType<? extends ItemLaserEntity>)((EntityType)YHEntities.ITEM_LASER.get()), this.shooter(), this.self().m_9236_());
        danmaku.setItem(type.get(color).asStack());
        danmaku.setup(this.getDamage(type), life, len, true, vec);
        danmaku.m_146884_(pos);
        danmaku.setupLength = type.setupLength();
        return danmaku;
    }

    @Override
    default public ShooterEntity prepareShooter(ShooterData data, SpellCard spell) {
        ShooterEntity ans = new ShooterEntity((EntityType<? extends LivingEntity>)((EntityType)YHEntities.SHOOTER.get()), this.self().m_9236_());
        ans.setup(this.shooter(), this.targetEntity(), data, spell);
        return ans;
    }

    @Override
    default public void shoot(Entity danmaku) {
        Level level = this.self().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            EntityStorageHelper.fastAdd(sl, danmaku);
        }
    }
}

