/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.player;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class RemiliaItemSpell
extends ItemSpell {
    @Override
    public void start(Player player, @Nullable LivingEntity target) {
        super.start(player, target);
        Vec3 nor = DanmakuHelper.getOrientation(this.dir).normal();
        this.addTicker(new Sweep().init(this.dir, nor, -90.0, 15.0, 8.0, 1.6, 2.4, 20, 15, 80));
    }

    @SerialClass
    public static class Sweep
    extends Ticker<RemiliaItemSpell> {
        @SerialClass.SerialField
        private Vec3 dir;
        @SerialClass.SerialField
        private Vec3 nor;
        @SerialClass.SerialField
        private double initialAngle;
        @SerialClass.SerialField
        private double horSpread;
        @SerialClass.SerialField
        private double verSpread;
        @SerialClass.SerialField
        private double lowSpeed;
        @SerialClass.SerialField
        private double highSpeed;
        @SerialClass.SerialField
        private int duration;
        @SerialClass.SerialField
        private int count;
        @SerialClass.SerialField
        private int range;

        public Sweep init(Vec3 dir, Vec3 nor, double initialAngle, double horSpread, double verSpread, double lowSpeed, double highSpeed, int duration, int count, int range) {
            this.dir = dir;
            this.nor = nor;
            this.initialAngle = initialAngle;
            this.horSpread = horSpread;
            this.verSpread = verSpread;
            this.lowSpeed = lowSpeed;
            this.highSpeed = highSpeed;
            this.duration = duration;
            this.count = count;
            this.range = range;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, RemiliaItemSpell card) {
            double a0 = this.initialAngle + 360.0 / (double)this.duration * (double)this.tick;
            RandomSource rand = holder.random();
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir, this.nor);
            for (int i = 0; i < this.count; ++i) {
                double a1 = a0 + this.horSpread * (rand.m_188500_() * 2.0 - 1.0);
                double a2 = this.verSpread * rand.m_188583_();
                double v0 = this.lowSpeed + (this.highSpeed - this.lowSpeed) * rand.m_188500_();
                int t = (int)Math.ceil((double)this.range / v0 * (1.0 + rand.m_188500_() * 0.1));
                Vec3 d = o.rotateDegrees(a1, a2);
                ItemDanmakuEntity e = holder.prepareDanmaku(t, d.m_82490_(v0), YHDanmaku.Bullet.BUBBLE, DyeColor.RED);
                holder.shoot(e);
                double mid = 0.6 + 0.3 * rand.m_188500_();
                e = holder.prepareDanmaku((int)((double)t / mid * 0.8), d.m_82490_(v0 * mid), YHDanmaku.Bullet.MENTOS, DyeColor.RED);
                holder.shoot(e);
                double low = 0.3 + 0.3 * rand.m_188500_();
                e = holder.prepareDanmaku((int)((double)t / low * 0.6), d.m_82490_(v0 * low), YHDanmaku.Bullet.BALL, DyeColor.RED);
                holder.shoot(e);
            }
            super.tick(holder, card);
            return this.tick > this.duration;
        }
    }
}

