/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.mover;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverInfo;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.TargetPosMover;
import net.minecraft.world.phys.Vec3;

@SerialClass
public final class PolarMover
extends TargetPosMover {
    @SerialClass.SerialField
    public Vec3 p;
    @SerialClass.SerialField
    public Vec3 v;
    @SerialClass.SerialField
    public Vec3 a;
    @SerialClass.SerialField
    public Vec3 n;
    @SerialClass.SerialField
    public Vec3 f;
    @SerialClass.SerialField
    public double r;
    @SerialClass.SerialField
    public double vr;
    @SerialClass.SerialField
    public double va;
    @SerialClass.SerialField
    public double th;
    @SerialClass.SerialField
    public double w;
    @SerialClass.SerialField
    public double b;

    @Deprecated
    public PolarMover() {
    }

    public PolarMover(Vec3 p, Vec3 v, Vec3 a, Vec3 n, Vec3 f) {
        this.p = p;
        this.v = v;
        this.a = a;
        this.n = n;
        this.f = f;
    }

    public static PolarMover ofPlane(Vec3 pos, Vec3 a1, Vec3 a2) {
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(a1, a2);
        return new PolarMover(pos, Vec3.f_82478_, Vec3.f_82478_, ori.normal(), ori.forward());
    }

    @Override
    public Vec3 pos(MoverInfo info) {
        return this.pos(info.tick());
    }

    public Vec3 pos(double tick) {
        Vec3 rect = this.p.m_82549_(this.v.m_82490_(tick)).m_82549_(this.a.m_82490_(tick * tick * 0.5));
        Vec3 polar = DanmakuHelper.getOrientation(this.f, this.n).rotate(this.th + this.w * tick + this.b * tick * tick * 0.5).m_82490_(this.r + this.vr * tick + this.va * tick * tick * 0.5);
        return rect.m_82549_(polar);
    }

    public Vec3 dir(double tick) {
        return this.pos(tick + 0.001).m_82546_(this.pos(tick)).m_82490_(1000.0);
    }

    public PolarMover copy() {
        return new PolarMover(this.p, this.v, this.a, this.n, this.f).radial(this.r, this.vr, this.va).angular(this.th, this.w, this.b);
    }

    public PolarMover radial(double r, double vr, double va) {
        this.r = r;
        this.vr = vr;
        this.va = va;
        return this;
    }

    public PolarMover angular(double th, double w, double b) {
        this.th = th;
        this.w = w;
        this.b = b;
        return this;
    }

    public PolarMover atTime(int tick) {
        this.p = this.p.m_82549_(this.v.m_82490_((double)tick)).m_82549_(this.a.m_82490_((double)(tick * tick) * 0.5));
        this.r += this.vr * (double)tick + this.va * (double)tick * (double)tick * 0.5;
        this.th += this.w * (double)tick + this.b * (double)tick * (double)tick * 0.5;
        this.v = this.v.m_82549_(this.a.m_82490_((double)tick));
        this.vr += this.va * (double)tick;
        this.w += this.b * (double)tick;
        return this;
    }

    public PolarMover clearAccel() {
        this.a = Vec3.f_82478_;
        this.b = 0.0;
        this.va = 0.0;
        return this;
    }

    public RectMover toRect() {
        return new RectMover(this.pos(0.0), this.dir(0.0), Vec3.f_82478_);
    }
}

