/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterData;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class KisinSpell
extends ActualSpellCard {
    @SerialClass.SerialField
    private int cooldown;

    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.cooldown > 0) {
            return;
        }
        Vec3 target = holder.target();
        if (target == null) {
            return;
        }
        Vec3 center = holder.center();
        double dist = center.m_82554_(target);
        if (dist < 10.0) {
            this.addTicker(new SummonNear());
            this.cooldown = 60;
            return;
        }
        if (dist < 40.0 && holder.random().m_188499_()) {
            this.addTicker(new Wing());
            this.cooldown = 60;
            return;
        }
        this.addTicker(new SummonFar());
        this.cooldown = 80;
    }

    @SerialClass
    public static class SummonNear
    extends Ticker<KisinSpell> {
        @Override
        public boolean tick(CardHolder holder, KisinSpell card) {
            super.tick(holder, card);
            Vec3 target = holder.target();
            if (target == null) {
                return true;
            }
            int life = 60;
            if (this.tick % 2 == 0) {
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(target.m_82546_(holder.center()).m_82541_());
                double x = holder.random().m_188500_() * 60.0 - 30.0;
                double y = holder.random().m_188500_() * 60.0 - 30.0;
                Vec3 dir = o.rotateDegrees(x, y);
                ShooterEntity e = holder.prepareShooter(new ShooterData(40, holder.getDamage(YHDanmaku.Bullet.CIRCLE), life), new SubSpell().init(dir, life, this.tick / 2 % 2 == 0 ? DyeColor.YELLOW : DyeColor.ORANGE));
                e.mover = new RectMover(holder.center(), dir.m_82490_(0.5), Vec3.f_82478_);
                holder.shoot((Entity)e);
            }
            return this.tick > 40;
        }

        @SerialClass
        public class SubSpell
        extends ActualSpellCard {
            @SerialClass.SerialField
            private Vec3 dir;
            @SerialClass.SerialField
            private int life;
            @SerialClass.SerialField
            private DyeColor color;

            public SubSpell init(Vec3 dir, int life, DyeColor color) {
                this.dir = dir;
                this.life = life;
                this.color = color;
                return this;
            }

            @Override
            public void tick(CardHolder holder) {
                super.tick(holder);
                int bulletLife = 40;
                double forward = 0.8;
                double backward = -0.3;
                --this.life;
                if (this.life > 0) {
                    holder.shoot(holder.prepareDanmaku(bulletLife, this.dir.m_82490_(forward), YHDanmaku.Bullet.CIRCLE, this.color));
                    holder.shoot(holder.prepareDanmaku(bulletLife, this.dir.m_82490_(backward), YHDanmaku.Bullet.CIRCLE, this.color));
                }
            }
        }
    }

    @SerialClass
    public static class Wing
    extends Ticker<KisinSpell> {
        @SerialClass.SerialField
        public Vec3 pos;
        @SerialClass.SerialField
        public Vec3 dir;

        @Override
        public boolean tick(CardHolder holder, KisinSpell card) {
            Vec3 target = holder.target();
            if (target == null) {
                return true;
            }
            if (this.pos == null || this.dir == null) {
                this.pos = holder.center();
                this.dir = target.m_82546_(this.pos).m_82541_();
                int s = holder.random().m_188499_() ? 1 : -1;
                this.dir = DanmakuHelper.getOrientation(this.dir).rotateDegrees(s * 90);
            }
            double v0 = 0.7;
            int life = 80;
            Vec3 p = this.pos.m_82549_(this.dir.m_82490_(v0 * (double)this.tick)).m_82520_(holder.random().m_188583_(), holder.random().m_188583_(), holder.random().m_188583_());
            Vec3 d0 = target.m_82546_(p).m_82541_();
            double x = holder.random().m_188500_() * 20.0 - 10.0;
            double y = holder.random().m_188500_() * 20.0 - 10.0;
            for (int i = -1; i <= 1; ++i) {
                Vec3 d1 = DanmakuHelper.getOrientation(d0).rotateDegrees(x + (double)(i * 30), y);
                ItemLaserEntity l = holder.prepareLaser(life, p, d1, 80.0f, YHDanmaku.Laser.LASER, DyeColor.YELLOW);
                l.setupTime(5, 5, life, 10);
                holder.shoot(l);
            }
            ++this.tick;
            return this.tick > 40;
        }
    }

    @SerialClass
    public static class SummonFar
    extends Ticker<KisinSpell> {
        @SerialClass.SerialField
        private DyeColor color;

        @Override
        public boolean tick(CardHolder holder, KisinSpell card) {
            super.tick(holder, card);
            Vec3 target = holder.target();
            if (target == null) {
                return true;
            }
            if (this.color == null) {
                this.color = holder.random().m_188499_() ? DyeColor.MAGENTA : DyeColor.BLUE;
            }
            int life = 40;
            double speed = 0.5;
            double x = holder.random().m_188583_() * 20.0;
            double z = holder.random().m_188583_() * 20.0;
            int y = 20;
            Vec3 pos = target.m_82520_(x, (double)y, z);
            ShooterEntity e = holder.prepareShooter(new ShooterData(40, holder.getDamage(YHDanmaku.Bullet.CIRCLE), life), new SubSpell().init(life, this.color, card));
            e.m_146884_(pos);
            e.mover = new RectMover(pos, new Vec3(0.0, -speed, 0.0), Vec3.f_82478_);
            holder.shoot((Entity)e);
            return this.tick > 40;
        }

        @SerialClass
        public class SubSpell
        extends ActualSpellCard {
            @SerialClass.SerialField
            private int life;
            @SerialClass.SerialField
            private DyeColor color;
            private KisinSpell root;

            public SubSpell init(int life, DyeColor color, KisinSpell root) {
                this.life = life;
                this.color = color;
                this.root = root;
                return this;
            }

            @Override
            public void tick(CardHolder holder) {
                super.tick(holder);
                if (this.root == null) {
                    return;
                }
                int bulletLife = 40;
                --this.life;
                if (this.life > 0) {
                    this.root.addTicker(new Delayed().init(holder.center(), bulletLife, this.color));
                }
            }

            @SerialClass
            public static class Delayed
            extends Ticker<KisinSpell> {
                @SerialClass.SerialField
                private int life;
                @SerialClass.SerialField
                private Vec3 pos;
                @SerialClass.SerialField
                private DyeColor color;

                public Delayed init(Vec3 pos, int life, DyeColor color) {
                    this.pos = pos;
                    this.life = life;
                    this.color = color;
                    return this;
                }

                @Override
                public boolean tick(CardHolder holder, KisinSpell card) {
                    Vec3 target = holder.target();
                    if (target == null) {
                        return true;
                    }
                    int l = this.life;
                    double speed = 1.0;
                    if (this.tick == 0) {
                        ItemDanmakuEntity e = holder.prepareDanmaku(l, Vec3.f_82478_, YHDanmaku.Bullet.CIRCLE, this.color);
                        e.m_146884_(this.pos);
                        holder.shoot(e);
                    } else if (this.tick == this.life) {
                        Vec3 dir = target.m_82546_(this.pos).m_82541_();
                        ItemDanmakuEntity e = holder.prepareDanmaku(l, dir.m_82490_(speed), YHDanmaku.Bullet.CIRCLE, this.color);
                        e.m_146884_(this.pos);
                        holder.shoot(e);
                        return true;
                    }
                    ++this.tick;
                    return false;
                }
            }
        }
    }
}

