/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.custom.forms;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.RingFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.RingSpellFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.forms.ISpellForm;
import dev.xkmc.youkaishomecoming.content.spell.item.PlayerHolder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class RingSpellForm
extends ISpellForm<RingSpellFormData> {
    @SerialClass.SerialField
    private RingSpellFormData data;
    @SerialClass.SerialField
    private int step;
    @SerialClass.SerialField
    private int tick;

    @Override
    public void init(RingSpellFormData data) {
        this.data = data;
    }

    @Override
    public boolean tick(Player player) {
        if (this.holder == null) {
            this.holder = new PlayerHolder(player, this.dir, this, null);
        }
        DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir);
        RingFormData form = this.data.form();
        int n = form.branches();
        RandomSource rand = this.holder.random();
        while (this.tick >= this.step * form.delay() && this.step < form.steps()) {
            double s0 = form.steps() <= 1 ? this.data.speedFirst() : Mth.m_14139_((double)(1.0 * (double)this.step / (double)(form.steps() - 1)), (double)this.data.speedFirst(), (double)this.data.speedLast());
            for (int i = 0; i < n; ++i) {
                double ax = ((double)i - (double)(n - 1) * 0.5) * form.branchAngle() + ((double)this.step - (double)(form.steps() - 1) * 0.5) * form.stepAngle();
                double ay = ((double)this.step - (double)(form.steps() - 1) * 0.5) * form.stepVerticalAngle();
                double rx = (rand.m_188500_() * 2.0 - 1.0) * form.randomizedAngle();
                double ry = (rand.m_188500_() * 2.0 - 1.0) * form.randomizedAngle();
                double s1 = s0 * (1.0 + (rand.m_188500_() * 2.0 - 1.0) * this.data.randomizedSpeed());
                Vec3 dir = o.rotateDegrees(ax + rx, ay + ry);
                ItemDanmakuEntity e = this.data.base().prepare(this.holder, dir, s1);
                this.holder.shoot(e);
            }
            ++this.step;
        }
        ++this.tick;
        return this.step >= form.steps() & super.tick(player);
    }
}

