/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.food;

import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.compat.diet.DietTagGen;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodModelHelper;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodTableItemHolder;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum YHRolls {
    SHINNKO_MAKI(FoodType.SIMPLE, 6, 0.8f, FoodModelHelper::hosomaki, List.of(), DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag),
    KAPPA_MAKI(FoodType.SIMPLE, 6, 0.8f, FoodModelHelper::hosomaki, List.of(), DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag),
    TEKKA_MAKI(FoodType.MEAT, 7, 1.0f, FoodModelHelper::hosomaki, List.of(new EffectEntry(() -> MobEffects.f_19593_, 200, 0, 0.2f)), DietTagGen.PROTEINS.tag, DietTagGen.GRAINS.tag),
    EGG_FUTOMAKI(FoodType.SIMPLE, 4, 0.8f, FoodModelHelper::futomaki, List.of(), DietTagGen.PROTEINS.tag, DietTagGen.GRAINS.tag),
    SALMON_FUTOMAKI(FoodType.MEAT, 5, 1.0f, FoodModelHelper::futomaki, List.of(), DietTagGen.PROTEINS.tag, DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag),
    RAINBOW_FUTOMAKI(FoodType.MEAT, 6, 1.0f, FoodModelHelper::futomaki, List.of(), DietTagGen.PROTEINS.tag, DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag),
    CALIFORNIA_ROLL(FoodType.MEAT, 5, 0.9f, FoodModelHelper::cali, List.of(), DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    ROE_CALIFORNIA_ROLL(FoodType.MEAT, 6, 1.0f, null, List.of(new EffectEntry(() -> MobEffects.f_19592_, 200, 0, 0.35f), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 600, 0, 1.0f)), DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    SALMON_LOVER_ROLL(FoodType.MEAT, 7, 1.2f, null, List.of(new EffectEntry(() -> MobEffects.f_19592_, 200, 0, 0.6f), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 1200, 0, 1.0f)), DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    VOLCANO_ROLL(FoodType.MEAT, 7, 1.2f, null, List.of(new EffectEntry(() -> MobEffects.f_19593_, 200, 0, 0.6f), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 1200, 0, 1.0f)), DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    RAINBOW_ROLL(FoodType.MEAT, 8, 1.2f, null, List.of(new EffectEntry(() -> MobEffects.f_19592_, 200, 0, 0.35f), new EffectEntry(() -> MobEffects.f_19593_, 200, 0, 0.35f), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 1200, 0, 1.0f)), DietTagGen.GRAINS.tag, DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag);

    @Nullable
    public final FoodTableItemHolder model;
    public final ItemEntry<Item> item;
    public final ItemEntry<Item> slice;

    private YHRolls(FoodType type, @Nullable int nutrition, float sat, Function<String, FoodTableItemHolder> modelFactory, List<EffectEntry> effs, TagKey<Item> ... tags) {
        String name = this.name().toLowerCase(Locale.ROOT);
        int count = this.getCount();
        int rollNut = nutrition * count * 2 / 3;
        this.item = type.build(name, rollNut, sat, tags, this.scale(effs, count, (int)((float)(nutrition * count) * (1.0f + sat * 2.0f)))).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/food/maki/" + ctx.getName())})).register();
        type = switch (type) {
            case FoodType.MEAT -> FoodType.MEAT_SLICE;
            case FoodType.SIMPLE -> FoodType.FAST;
            case FoodType.FLESH -> FoodType.FLESH_FAST;
            default -> throw new IllegalArgumentException("State should have fast variant");
        };
        this.slice = type.build(name + "_slice", nutrition, sat, tags, effs).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/food/maki/" + ctx.getName())})).register();
        if (modelFactory != null) {
            this.model = modelFactory.apply(name);
            FoodModelHelper.map(this.item.getId(), this.model);
        } else {
            this.model = null;
        }
    }

    private List<EffectEntry> scale(List<EffectEntry> effs, int n, int sat) {
        ArrayList<EffectEntry> ans = new ArrayList<EffectEntry>();
        for (EffectEntry e : effs) {
            float chance = e.chance();
            int dur = e.duration();
            if (chance * (float)n < 1.0f) {
                ans.add(new EffectEntry(e.eff(), dur, e.amplifier(), chance * (float)n));
                continue;
            }
            ans.add(new EffectEntry(e.eff(), (int)((float)dur * chance * (float)n), e.amplifier(), 1.0f));
        }
        if (sat > 40) {
            ans.add(new EffectEntry(() -> MobEffects.f_19618_, sat - 20, 0));
        }
        return ans;
    }

    public static void init() {
    }

    public int getCount() {
        return this.name().endsWith("_MAKI") ? 3 : 6;
    }

    public ItemStack sliceStack() {
        return this.slice.asStack(this.getCount());
    }
}

