/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.board;

import dev.xkmc.l2library.base.overlay.OverlayUtil;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileClientTooltip;
import dev.xkmc.youkaishomecoming.content.pot.table.board.CuisineBoardBlockEntity;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class HintOverlay
implements IGuiOverlay {
    private int start = 0;

    public void render(ForgeGui gui, GuiGraphics g, float pTick, int w, int h) {
        int prev = this.start;
        this.start = 0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bhit = (BlockHitResult)hit;
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(bhit.m_82425_());
        if (!(blockEntity instanceof CuisineBoardBlockEntity)) {
            return;
        }
        CuisineBoardBlockEntity be = (CuisineBoardBlockEntity)blockEntity;
        if (prev == 0 || prev > player.f_19797_) {
            prev = player.f_19797_;
        }
        this.start = prev;
        int time = player.f_19797_ - this.start;
        if (time < 15) {
            return;
        }
        List<Ingredient> list = be.getModel().getHints(level);
        Int2ObjectLinkedOpenHashMap set = new Int2ObjectLinkedOpenHashMap();
        for (Ingredient e : list) {
            if (e.m_43947_()) {
                set.put(1, (Object)new ItemStack[0]);
                continue;
            }
            ItemStack[] stacks = e.m_43908_();
            int result = 1;
            for (ItemStack stack : stacks) {
                int hash;
                if (stack.m_41619_()) {
                    hash = 0;
                } else {
                    hash = BuiltInRegistries.f_257033_.m_7447_((Object)stack.m_41720_());
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        hash += tag.hashCode() * 15;
                    }
                }
                result = 31 * result + hash;
            }
            set.put(result, (Object)stacks);
        }
        int total = set.size();
        if (total == 0) {
            return;
        }
        ArrayList stacks = new ArrayList(set.values());
        int n = Math.min(total, 12);
        ItemStack[] display = new ItemStack[n];
        for (int i = 0; i < n; ++i) {
            ItemStack[] arr = (ItemStack[])stacks.get(i);
            display[i] = arr.length == 0 ? YHItems.EMPTY_HAND_ICON.asStack(1) : arr[time / 15 % arr.length];
        }
        new ImageBox(g, (int)((double)w * 0.7), (int)((double)h * 0.5), 0).render(display, Math.min(4, n), Math.min(3, (n - 1) / 4 + 1), total - n);
    }

    public static class ImageBox
    extends OverlayUtil {
        public ImageBox(GuiGraphics g, int x0, int y0, int maxW) {
            super(g, x0, y0, maxW);
        }

        public void render(ItemStack[] stacks, int w, int h, int extra) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(new ClientTextTooltip(YHLangData.CUISINE_ALLOW.get(new Object[0]).m_7532_()));
            tooltip.add(new TileClientTooltip(List.of(stacks), List.of(), w, h));
            if (extra > 0) {
                tooltip.add(new ClientTextTooltip(YHLangData.CUISINE_EXTRA.get("" + extra).m_7532_()));
            }
            this.renderTooltipInternal(Minecraft.m_91087_().f_91062_, tooltip);
        }
    }
}

