/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.kettle;

import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public record WrappedFluidTank(KettleBlockEntity be) implements IFluidHandler
{
    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack((Fluid)Fluids.f_76193_, this.be.getWater());
    }

    public int getTankCapacity(int tank) {
        return 600;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.getFluid() == Fluids.f_76193_;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(0, resource)) {
            return 0;
        }
        int ans = Math.min(resource.getAmount(), this.getTankCapacity(0) - this.be.getWater());
        if (action.execute()) {
            this.be.addWater(ans);
        }
        return ans;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(0, resource)) {
            return FluidStack.EMPTY;
        }
        int ans = Math.min(resource.getAmount(), this.be.getWater());
        if (action.execute()) {
            this.be.addWater(-ans);
        }
        return new FluidStack((Fluid)Fluids.f_76193_, ans);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int ans = Math.min(maxDrain, this.be.getWater());
        if (action.execute()) {
            this.be.addWater(-ans);
        }
        return new FluidStack((Fluid)Fluids.f_76193_, ans);
    }
}

