/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ItemDanmakuRenderer<T extends ItemDanmakuEntity>
extends EntityRenderer<T>
implements ProjectileRenderer<T> {
    public ItemDanmakuRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    protected int getBlockLightLevel(T e, BlockPos pPos) {
        return ((ItemDanmakuEntity)e).fullBright() ? 15 : super.m_6086_(e, pPos);
    }

    @Override
    public double fading(SimplifiedProjectile e) {
        double global;
        if (this.f_114476_.f_114358_.m_90592_() == e.m_19749_()) {
            double dist = this.f_114476_.f_114358_.m_90583_().m_82554_(e.m_20182_());
            double fading = (Double)YHModConfig.CLIENT.selfDanmakuFading.get();
            return Math.min((dist - 2.0) / 12.0, 1.0) * fading;
        }
        double fading = (Double)YHModConfig.CLIENT.farDanmakuFading.get();
        double d = global = GrazeHelper.globalInvulTime > 0 ? (Double)YHModConfig.CLIENT.selfDanmakuFading.get() : 1.0;
        if (fading == 0.0) {
            return global;
        }
        double dist = this.f_114476_.f_114358_.m_90583_().m_82554_(e.m_20182_());
        double start = (Double)YHModConfig.CLIENT.fadingStart.get();
        double end = (Double)YHModConfig.CLIENT.fadingEnd.get();
        if (dist < start) {
            return global;
        }
        return (1.0 - Math.min((dist - start) / (end - start), 1.0) * fading) * global;
    }

    public boolean shouldRender(T e, Frustum frustum, double camx, double camy, double camz) {
        Entity cam = this.f_114476_.f_114358_.m_90592_();
        if (((SimplifiedProjectile)e).m_19749_() != cam || ((ItemDanmakuEntity)e).f_19797_ >= 40) {
            return true;
        }
        double dh = e.m_20206_() / 2.0f;
        double dist = cam.m_146892_().m_82557_(e.m_20182_().m_82520_(0.0, dh, 0.0));
        double dy = Math.abs(cam.m_20188_() - e.m_20186_() - dh);
        return dist > 12.0 || dy > 0.1 + dh * 2.0 && dist > 4.0;
    }

    @Override
    public Quaternionf cameraOrientation() {
        return this.f_114476_.m_253208_();
    }

    public void render(T e, float yaw, float pTick, PoseStack pose, MultiBufferSource buffer, int light) {
        this.render(e, pTick, pose);
    }

    public Vec3 getRenderOffset(T e, float f) {
        return new Vec3(0.0, (double)(e.m_20206_() / 2.0f), 0.0);
    }

    @Override
    public void render(T e, float pTick, PoseStack pose) {
        Item item = ((ItemDanmakuEntity)e).m_7846_().m_41720_();
        if (!(item instanceof DanmakuItem)) {
            return;
        }
        DanmakuItem danmaku = (DanmakuItem)item;
        pose.m_85836_();
        float scale = ((ItemDanmakuEntity)e).scale();
        pose.m_85841_(scale, scale, scale);
        danmaku.getTypeForRender().create(this, (SimplifiedProjectile)e, pose, pTick);
        pose.m_85849_();
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.f_118259_;
    }
}

