/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.boss;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.youkai.GeneralYoukaiEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class BossYoukaiEntity
extends GeneralYoukaiEntity {
    protected final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20);
    private boolean ticking = false;
    @SerialClass.SerialField
    private ResourceLocation spawnDimension;
    private int hurtCD = 0;
    private boolean hurtCall = false;
    private boolean chaotic = false;
    private float illegalDamage = 0.0f;
    @SerialClass.SerialField
    protected int noTargetTime;

    public static AttributeSupplier.Builder createAttributes() {
        return YoukaiEntity.createAttributes().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    public BossYoukaiEntity(EntityType<? extends BossYoukaiEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GeneralYoukaiEntity>)pEntityType, pLevel);
        this.m_21530_();
    }

    @Override
    public boolean shouldHurt(LivingEntity le) {
        if (this.shouldIgnore(le)) {
            return false;
        }
        return le instanceof Enemy || super.shouldHurt(le);
    }

    public boolean m_7301_(MobEffectInstance ins) {
        return false;
    }

    @Override
    public void m_8119_() {
        if (this.spawnDimension == null) {
            this.spawnDimension = this.m_9236_().m_46472_().m_135782_();
        } else if (!this.spawnDimension.equals((Object)this.m_9236_().m_46472_().m_135782_()) && !((Boolean)YHModConfig.COMMON.canReimuTeleportToOtherDimension.get()).booleanValue()) {
            this.m_146870_();
        }
        this.ticking = true;
        double maxSpeed = 0.5;
        if (this.m_20184_().m_82553_() > maxSpeed) {
            this.m_20256_(this.m_20184_().m_82541_().m_82490_(maxSpeed));
        }
        this.validateData();
        super.m_8119_();
        this.ticking = false;
    }

    @Override
    public void m_8107_() {
        if (this.hurtCD < 1000) {
            ++this.hurtCD;
        }
        super.m_8107_();
        if (!this.m_21221_().isEmpty()) {
            this.m_21219_();
        }
    }

    protected int getCD(DamageSource source) {
        if (!((Boolean)YHModConfig.COMMON.reimuExtraDamageCoolDown.get()).booleanValue()) {
            return 10;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return 10;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            if (pl.m_150110_().f_35937_) {
                return 10;
            }
        }
        if (source.m_276093_(YHDamageTypes.DANMAKU)) {
            return 20;
        }
        if (source.m_269533_(DamageTypeTags.f_273918_)) {
            return 30;
        }
        return 50;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity le;
        if (this.ticking || source.m_7639_() == this) {
            if (!source.m_276093_(DamageTypes.f_286979_)) {
                return false;
            }
            LivingEntity target = this.m_5448_();
            if (target != null && amount >= this.getCombatProgress() && !this.m_213877_()) {
                this.trySummonReinforcementOnDeath(target);
                this.m_146870_();
            }
        }
        if (this.m_5448_() instanceof Player && !(source.m_7639_() instanceof Player)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            le = (LivingEntity)entity;
            this.m_6703_(le);
            this.targets.checkTarget();
        }
        if (!source.m_276093_(DamageTypes.f_286979_) || source.m_7639_() != null) {
            if (!source.m_269533_(DamageTypeTags.f_268738_) && !(source.m_7639_() instanceof LivingEntity)) {
                return false;
            }
            entity = source.m_7639_();
            if (entity instanceof LivingEntity && this.shouldIgnore(le = (LivingEntity)entity)) {
                return false;
            }
            int cd = this.getCD(source);
            if (this.hurtCD < cd) {
                return false;
            }
        }
        this.hurtCD = 0;
        this.hurtCall = true;
        boolean ans = super.m_6469_(source, amount);
        this.hurtCall = false;
        return ans;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void notifyIllegalDamage(float amount, @Nullable Entity causer) {
        this.illegalDamage += amount;
        if (this.illegalDamage > 200.0f) {
            this.setFlag(32, true);
        }
    }

    protected float clampDamage(DamageSource source, float amount) {
        if (!this.hurtCall) {
            this.notifyIllegalDamage(amount, source.m_7639_());
            return 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                ServerPlayer sp;
                LivingEntity le = (LivingEntity)entity;
                if (le instanceof ServerPlayer && (sp = (ServerPlayer)le).m_7500_()) {
                    return amount;
                }
            } else {
                if (source.m_276093_(DamageTypes.f_268724_)) {
                    if (amount > 4.0f) {
                        this.notifyIllegalDamage(amount - 4.0f, source.m_7639_());
                    }
                    return Math.min(4.0f, amount);
                }
                if (source.m_276093_(DamageTypes.f_286979_)) {
                    return amount;
                }
            }
        }
        int reduction = this.damageLimit();
        float ans = Math.min(this.m_21233_() / (float)reduction, amount);
        if (((Boolean)YHModConfig.COMMON.reimuDamageReduction.get()).booleanValue() && !source.m_269533_(YHDamageTypes.DANMAKU_TYPE)) {
            ans /= (float)this.nonDanmakuReduction();
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.notifyIllegalDamage(amount - ans, source.m_7639_());
        }
        return ans;
    }

    protected int damageLimit() {
        return 20;
    }

    protected int nonDanmakuReduction() {
        return 5;
    }

    @Override
    protected final void m_6475_(DamageSource source, float amount) {
        if (!this.hurtCall) {
            this.notifyIllegalDamage(amount, source.m_7639_());
            return;
        }
        super.m_6475_(source, amount);
    }

    @Override
    protected void hurtFinal(DamageSource source, float amount) {
        if (!Float.isFinite(amount)) {
            return;
        }
        if ((amount = this.clampDamage(source, amount)) <= 0.0f) {
            return;
        }
        super.hurtFinal(source, amount);
    }

    @Override
    public void m_21153_(float val) {
        if (!Float.isFinite(val)) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            this.setCombatProgress(val);
        }
        float health = this.getCombatProgress();
        if (this.f_19797_ > 5 && val <= health) {
            this.notifyIllegalDamage(health - val, null);
            return;
        }
        this.setCombatProgress(val);
    }

    @Override
    public void setCombatProgress(float amount) {
        if (this.combatProgress != null) {
            float health = this.combatProgress.progress;
            if (health > this.getVanillaProgress()) {
                this.notifyIllegalDamage(health - this.getVanillaProgress(), null);
            }
            if (health > this.getCombatProgress()) {
                this.notifyIllegalDamage(health - this.getCombatProgress(), null);
                this.setFlag(32, true);
            }
        }
        super.setCombatProgress(amount);
    }

    public void m_5634_(float original) {
        float heal = ForgeEventFactory.onLivingHeal((LivingEntity)this, (float)original);
        if ((heal = Math.max(original, heal)) <= 0.0f) {
            return;
        }
        float f = this.getCombatProgress();
        if (f > 0.0f) {
            this.m_21153_(f + heal);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.combatProgress != null && this.getCombatProgress() != this.combatProgress.progress) {
            this.bossEvent.m_142711_(this.random().m_188501_());
            return;
        }
        this.bossEvent.m_142711_(this.getCombatProgress() / this.m_21233_());
        if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            LivingEntity livingEntity;
            this.chaotic = false;
            ++this.noTargetTime;
            boolean doHeal = this.noTargetTime >= 20 && this.f_19797_ % 20 == 0;
            if ((doHeal |= this.getCombatProgress() < this.m_21233_()) && (livingEntity = this.m_21188_()) instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_150110_().f_35937_ && this.f_19797_ - this.m_21213_() < 100) {
                    doHeal = false;
                }
            }
            if (doHeal) {
                this.m_21153_(this.m_21233_());
                if (this.getFlag(32)) {
                    this.setFlag(32, false);
                }
            }
        } else {
            this.noTargetTime = 0;
        }
    }

    public boolean isChaotic() {
        return this.getFlag(32) || this.chaotic || this.combatProgress != null && this.getCombatProgress() != this.combatProgress.progress;
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public boolean m_6072_() {
        return (Boolean)YHModConfig.COMMON.canReimuTeleportToOtherDimension.get();
    }
}

