/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.rope;

import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public abstract class RopeLoggedCropBlock
extends CropBlock
implements HarvestableBlock {
    public static final BooleanProperty ROPELOGGED = BooleanProperty.m_61465_((String)"ropelogged");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public static boolean isRope(BlockState state) {
        return (Boolean)Configuration.ENABLE_TOMATO_VINE_CLIMBING_TAGGED_ROPES.get() != false ? state.m_204336_(ModTags.ROPES) : state.m_60713_((Block)ModBlocks.ROPE.get());
    }

    public static BlockState getRopeBlock() {
        Block rope = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Configuration.DEFAULT_TOMATO_VINE_ROPE.get()));
        Block block = rope != null ? rope : (Block)ModBlocks.ROPE.get();
        return block.m_49966_();
    }

    public RopeLoggedCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract ItemLike m_6404_();

    protected abstract ItemLike getFruit();

    public abstract int getBaseAge();

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float speed;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!this.mayGrow(state, level, pos, random)) {
            return;
        }
        int age = this.m_52305_(state);
        if (this.mayGrowTo(state, (LevelReader)level, pos, age + 1) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (speed = RopeLoggedCropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.growTo(state, level, pos, age + 1);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
        this.postGrowth(level, pos, random);
    }

    protected boolean mayGrowTo(BlockState state, LevelReader level, BlockPos pos, int age) {
        return age <= this.m_7419_();
    }

    protected void growTo(BlockState state, ServerLevel level, BlockPos pos, int age) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age)), 2);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int maxAge;
        int newAge = this.m_52305_(state) + this.m_7125_((Level)level);
        if (newAge > (maxAge = this.m_7419_())) {
            newAge = maxAge;
        }
        if (this.mayGrowTo(state, (LevelReader)level, pos, newAge)) {
            this.growTo(state, level, pos, newAge);
        }
        this.postGrowth(level, pos, random);
    }

    public void postGrowth(ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected int m_7125_(Level level) {
        return super.m_7125_(level) / 2;
    }

    protected boolean mayGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        return level.m_45524_(pos, 0) >= 9;
    }

    protected void pickup(BlockState state, Level level, BlockPos pos, Player player) {
        int quantity = 1 + level.f_46441_.m_188503_(2);
        RopeLoggedCropBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(this.getFruit(), quantity));
        level.m_5594_(null, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.getBaseAge())), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        boolean isRope = false;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            isRope = RopeLoggedCropBlock.isRope(item2.m_40614_().m_49966_());
        }
        if (!isRope) {
            boolean isMature;
            int age = (Integer)state.m_61143_((Property)this.m_7959_());
            boolean bl = isMature = age == this.m_7419_();
            if (!isMature && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
                return InteractionResult.PASS;
            }
            if (isMature) {
                this.pickup(state, level, pos, player);
                return InteractionResult.SUCCESS;
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        if (!((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(true)), 2);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_(), ROPELOGGED});
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return (Boolean)state.m_61143_((Property)ROPELOGGED) != false && state.m_204336_(BlockTags.f_13082_);
    }

    public boolean hasGoodCropConditions(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        boolean rope = (Boolean)state.m_61143_((Property)ROPELOGGED);
        this.doPlayerDestroy(level, player, pos, state, be, stack);
        if (rope) {
            RopeLoggedCropBlock.destroyAndPlaceRope(level, pos);
        }
    }

    public void doPlayerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, state, be, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState fstate, LevelAccessor level, BlockPos cpos, BlockPos fpos) {
        if (!state.m_60710_((LevelReader)level, cpos)) {
            level.m_186460_(cpos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_46961_(pos, true);
        if (((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
            RopeLoggedCropBlock.destroyAndPlaceRope((Level)level, pos);
        }
    }

    public static void destroyAndPlaceRope(Level level, BlockPos pos) {
        level.m_46597_(pos, RopeLoggedCropBlock.getRopeBlock());
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos blockPos) {
        if ((Integer)state.m_61143_((Property)this.m_7959_()) < this.m_7419_()) {
            return null;
        }
        int quantity = 1 + level.f_46441_.m_188503_(2);
        return new HarvestResult((BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.getBaseAge())), List.of(new ItemStack(this.getFruit(), quantity)));
    }
}

