/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.BranchCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.CenterCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeLoggedCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public abstract class VineTrunkBlock
extends BushBlock
implements BonemealableBlock,
HarvestableBlock {
    public static final BooleanProperty MERGED = BooleanProperty.m_61465_((String)"merged");
    public static final VoxelShape SHAPE = VineTrunkBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected ItemLike seed;

    public VineTrunkBlock(BlockBehaviour.Properties prop, ItemLike seed) {
        super(prop.m_60977_());
        this.seed = seed;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MERGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MERGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.seed.m_5456_().m_7968_();
    }

    protected abstract CenterCropVineBlock getTop();

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        float speed = this.getGrowthSpeed((BlockGetter)level, pos) * 0.04f;
        this.attemptGrowth(state, (LevelReader)level, pos, random, false, true, speed);
    }

    protected boolean attemptGrowth(BlockState state, LevelReader level, BlockPos pos, @Nullable RandomSource random, boolean simulate, boolean natural, float speed) {
        boolean x;
        if (level.m_45524_(pos, 0) < 9) {
            return false;
        }
        if (!((Boolean)state.m_61143_((Property)MERGED)).booleanValue()) {
            if (simulate) {
                return true;
            }
            assert (random != null);
            Level setter = (Level)level;
            if (!natural) {
                setter.m_7731_(pos, (BlockState)state.m_61124_((Property)MERGED, (Comparable)Boolean.valueOf(true)), 2);
                return true;
            }
            if (ForgeHooks.onCropsGrowPre((Level)setter, (BlockPos)pos, (BlockState)state, (random.m_188501_() < speed ? 1 : 0) != 0)) {
                setter.m_7731_(pos, (BlockState)state.m_61124_((Property)MERGED, (Comparable)Boolean.valueOf(true)), 2);
                ForgeHooks.onCropsGrowPost((Level)setter, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
        BlockPos up = pos.m_7494_();
        BlockState cen = level.m_8055_(up);
        if (cen.m_60713_((Block)this.getTop())) {
            return this.getTop().attemptGrowth(cen, level, up, random, simulate, natural, speed);
        }
        if (!RopeLoggedCropBlock.isRope(cen)) {
            return false;
        }
        BlockState nor = level.m_8055_(up.m_122012_());
        BlockState sth = level.m_8055_(up.m_122019_());
        BlockState wst = level.m_8055_(up.m_122024_());
        BlockState est = level.m_8055_(up.m_122029_());
        boolean z = RopeLoggedCropBlock.isRope(nor) || RopeLoggedCropBlock.isRope(sth);
        boolean bl = x = RopeLoggedCropBlock.isRope(wst) || RopeLoggedCropBlock.isRope(est);
        if (!z && !x) {
            return false;
        }
        if (simulate) {
            return true;
        }
        assert (random != null);
        Level setter = (Level)level;
        if (z && x) {
            z = random.m_188499_();
        }
        if (natural && !ForgeHooks.onCropsGrowPre((Level)setter, (BlockPos)pos, (BlockState)state, (random.m_188501_() < speed ? 1 : 0) != 0)) {
            return false;
        }
        BlockState topState = this.getTop().m_49966_();
        if (z) {
            topState = (BlockState)topState.m_61124_(CenterCropVineBlock.AXIS, (Comparable)Direction.Axis.Z);
            if (RopeLoggedCropBlock.isRope(nor)) {
                topState = (BlockState)topState.m_61124_((Property)CenterCropVineBlock.LEFT, (Comparable)Boolean.valueOf(true));
                setter.m_7731_(up.m_122012_(), (BlockState)this.getTop().getSide().m_49966_().m_61124_((Property)BranchCropVineBlock.FACING, (Comparable)Direction.SOUTH), 2);
            }
            if (RopeLoggedCropBlock.isRope(sth)) {
                topState = (BlockState)topState.m_61124_((Property)CenterCropVineBlock.RIGHT, (Comparable)Boolean.valueOf(true));
                setter.m_7731_(up.m_122019_(), (BlockState)this.getTop().getSide().m_49966_().m_61124_((Property)BranchCropVineBlock.FACING, (Comparable)Direction.NORTH), 2);
            }
        } else {
            topState = (BlockState)topState.m_61124_(CenterCropVineBlock.AXIS, (Comparable)Direction.Axis.X);
            if (RopeLoggedCropBlock.isRope(wst)) {
                topState = (BlockState)topState.m_61124_((Property)CenterCropVineBlock.LEFT, (Comparable)Boolean.valueOf(true));
                setter.m_7731_(up.m_122024_(), (BlockState)this.getTop().getSide().m_49966_().m_61124_((Property)BranchCropVineBlock.FACING, (Comparable)Direction.EAST), 2);
            }
            if (RopeLoggedCropBlock.isRope(est)) {
                topState = (BlockState)topState.m_61124_((Property)CenterCropVineBlock.RIGHT, (Comparable)Boolean.valueOf(true));
                setter.m_7731_(up.m_122029_(), (BlockState)this.getTop().getSide().m_49966_().m_61124_((Property)BranchCropVineBlock.FACING, (Comparable)Direction.WEST), 2);
            }
        }
        setter.m_7731_(up, topState, 2);
        if (natural) {
            ForgeHooks.onCropsGrowPost((Level)setter, (BlockPos)up, (BlockState)topState);
        }
        return true;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean client) {
        return this.attemptGrowth(state, level, pos, null, true, false, 1.0f);
    }

    public boolean m_214167_(Level p_220878_, RandomSource p_220879_, BlockPos p_220880_, BlockState p_220881_) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.attemptGrowth(state, (LevelReader)level, pos, random, false, false, 1.0f);
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    protected float getGrowthSpeed(BlockGetter level, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = level.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(level, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)this)) {
                    f1 = 1.0f;
                    if (blockstate.m_60713_((Block)ModBlocks.RICH_SOIL.get()) || blockstate.m_60713_((Block)ModBlocks.RICH_SOIL_FARMLAND.get())) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos nor = pos.m_122012_();
        BlockPos sth = pos.m_122019_();
        BlockPos wst = pos.m_122024_();
        BlockPos est = pos.m_122029_();
        boolean flag = level.m_8055_(wst).m_60713_((Block)this) || level.m_8055_(est).m_60713_((Block)this);
        boolean bl = flag1 = level.m_8055_(nor).m_60713_((Block)this) || level.m_8055_(sth).m_60713_((Block)this);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = level.m_8055_(wst.m_122012_()).m_60713_((Block)this) || level.m_8055_(est.m_122012_()).m_60713_((Block)this) || level.m_8055_(est.m_122019_()).m_60713_((Block)this) || level.m_8055_(wst.m_122019_()).m_60713_((Block)this);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity be, ItemStack stack) {
        this.doPlayerDestroy(level, player, pos, state, be, stack);
        VineTrunkBlock.destroyAndPlaceRope(level, pos);
    }

    public void doPlayerDestroy(Level level, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, state, be, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState fstate, LevelAccessor level, BlockPos cpos, BlockPos fpos) {
        if (!state.m_60710_((LevelReader)level, cpos)) {
            level.m_186460_(cpos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_46961_(pos, true);
        VineTrunkBlock.destroyAndPlaceRope((Level)level, pos);
    }

    public static void destroyAndPlaceRope(Level level, BlockPos pos) {
        level.m_46597_(pos, RopeLoggedCropBlock.getRopeBlock());
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState blockState, BlockPos blockPos) {
        return null;
    }
}

