/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.youkaishomecoming.content.block.plant.grape.DoubleRopeCropBlock;
import dev.xkmc.youkaishomecoming.init.food.YHCrops;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class GrapeCropBlock
extends DoubleRopeCropBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)9);
    public static final VoxelShape[] LOWER = new VoxelShape[10];
    public static final VoxelShape[] UPPER = new VoxelShape[10];
    public static final VoxelShape[] ROPE_LOWER = new VoxelShape[10];
    public static final VoxelShape[] ROPE_UPPER = new VoxelShape[10];
    private final YHCrops crop;

    public GrapeCropBlock(BlockBehaviour.Properties properties, YHCrops crop) {
        super(properties);
        this.crop = crop;
    }

    @Override
    protected ItemLike m_6404_() {
        return this.crop.getSeed();
    }

    @Override
    protected ItemLike getFruit() {
        return this.crop.getFruits();
    }

    protected IntegerProperty m_7959_() {
        return AGE;
    }

    @Override
    public int getDoubleBlockStart() {
        return 4;
    }

    @Override
    public int getBaseAge() {
        return 6;
    }

    public int m_7419_() {
        return 9;
    }

    @Override
    protected int m_7125_(Level level) {
        return 1;
    }

    @Override
    protected boolean mayGrowTo(BlockState state, LevelReader level, BlockPos pos, int age) {
        if (((Boolean)state.m_61143_((Property)ROOT)).booleanValue() && age >= 2 && !((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
            return false;
        }
        return super.mayGrowTo(state, level, pos, age);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)this.m_7959_());
        boolean rope = (Boolean)state.m_61143_((Property)ROPELOGGED);
        boolean base = (Boolean)state.m_61143_((Property)ROOT);
        return (rope ? (base ? ROPE_LOWER : ROPE_UPPER) : (base ? LOWER : UPPER))[age];
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.canPerformAction(ToolActions.SHEARS_HARVEST) && (Integer)state.m_61143_((Property)this.m_7959_()) >= this.getBaseAge()) {
            if (!level.m_5776_()) {
                BlockState up;
                if (!((Boolean)state.m_61143_((Property)ROOT)).booleanValue()) {
                    pos = pos.m_7495_();
                }
                BlockState empty = (Boolean)(up = level.m_8055_(pos.m_7494_())).m_61143_((Property)ROPELOGGED) != false ? GrapeCropBlock.getRopeBlock() : Blocks.f_50016_.m_49966_();
                level.m_7731_(pos, this.crop.set.trunk.getDefaultState(), 2);
                level.m_7731_(pos.m_7494_(), empty, 35);
                BlockState down = level.m_8055_(pos.m_7495_());
                if (down.m_60713_(Blocks.f_50093_)) {
                    level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
                } else if (down.m_60713_((Block)ModBlocks.RICH_SOIL_FARMLAND.get())) {
                    level.m_7731_(pos.m_7495_(), ((Block)ModBlocks.RICH_SOIL.get()).m_49966_(), 2);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    YHCriteriaTriggers.GRAPE_CUT.m_222618_(sp);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    static {
        VoxelShape rod = GrapeCropBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        GrapeCropBlock.LOWER[0] = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)6.0, (double)14.0);
        GrapeCropBlock.LOWER[1] = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)9.0, (double)14.0);
        GrapeCropBlock.LOWER[2] = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
        GrapeCropBlock.LOWER[3] = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)15.0, (double)14.0);
        for (int i = 0; i < 4; ++i) {
            GrapeCropBlock.ROPE_LOWER[i] = Shapes.m_83110_((VoxelShape)LOWER[i], (VoxelShape)rod);
            GrapeCropBlock.UPPER[i] = Shapes.m_83040_();
            GrapeCropBlock.ROPE_UPPER[i] = rod;
        }
        VoxelShape full = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
        for (int i = 4; i < 10; ++i) {
            GrapeCropBlock.ROPE_LOWER[i] = GrapeCropBlock.LOWER[i] = full;
        }
        GrapeCropBlock.UPPER[4] = GrapeCropBlock.UPPER[5] = LOWER[1];
        GrapeCropBlock.ROPE_UPPER[4] = GrapeCropBlock.ROPE_UPPER[5] = ROPE_LOWER[1];
        VoxelShape top = GrapeCropBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)11.0, (double)14.0);
        VoxelShape rope_top = Shapes.m_83110_((VoxelShape)top, (VoxelShape)rod);
        for (int i = 6; i < 10; ++i) {
            GrapeCropBlock.UPPER[i] = top;
            GrapeCropBlock.ROPE_UPPER[i] = rope_top;
        }
    }
}

